<?php 
    if ( ! class_exists( 'Jetpack' ) ) {
        return;
    }

    $subscription_title         = iconic_blog_get_option( 'subscription_title');
    $subscription_description   = iconic_blog_get_option( 'subscription_description');
    $subscription_bnt_text     = iconic_blog_get_option( 'subscription_bnt_text');
?>
<div class="subscribe-wrapper clear">
    <div class="entry-container">
        <?php if ( !empty( $subscription_title ) ) { ?>
            <h3 class="section-title"><?php echo esc_html( $subscription_title ); ?></h3>
        <?php } ?>
        <?php if ( !empty( $subscription_description ) ) { ?>
            <div class="subscribe-text">
                <p><?php echo wp_kses_post( $subscription_description ); ?></p>
            </div>
        <?php } ?>
    </div>
    <?php 
    $subscription_shortcode = '[jetpack_subscription_form title="" subscribe_text="" subscribe_button="' . esc_html( $subscription_bnt_text ) . '" show_subscribers_total="0"]';
    echo do_shortcode( wp_kses_post( $subscription_shortcode ) ); 
    ?>
</div>