<?php
    $slider_title       = iconic_blog_get_option( 'slider_title' );
    $slider_subtitle       = iconic_blog_get_option( 'slider_subtitle' );
    $slider_content_type     = iconic_blog_get_option( 'slider_content_type' );
    $enable_category     = iconic_blog_get_option( 'slider_category_enable' );
    $enable_content     = iconic_blog_get_option( 'slider_content_enable' );
    $enable_author     = iconic_blog_get_option( 'slider_author_enable' );
    $enable_posted_on     = iconic_blog_get_option( 'slider_posted_on_enable' );
    $number_of_slider_items  = iconic_blog_get_option( 'number_of_slider_items' );
    $slider_category = iconic_blog_get_option( 'slider_category' );
    $header_font_size = iconic_blog_get_option( 'slider_font_size');
    $slider_column = iconic_blog_get_option('number_of_slider_column');
    $content_align = iconic_blog_get_option('slider_content_align');
    $excerpt_length =iconic_blog_get_option( 'slider_excerpt_length');
    $homepage_layout_options =iconic_blog_get_option( 'homepage_design_layout_options');

    $see_more_txt     = iconic_blog_get_option( 'slider_see_all_txt' );
    $see_more_url     = iconic_blog_get_option( 'slider_see_all_url' );

    for( $i=1; $i<=$number_of_slider_items; $i++ ) :
        $slider_page_posts[] = absint(iconic_blog_get_option( 'slider_page_'.$i ) );
        $slider_post_posts[] = absint(iconic_blog_get_option( 'slider_post_'.$i ) );
    endfor;

?>
<style>
    <?php if ($header_font_size != 0): ?>
        #slider .entry-title{
            font-size:<?php echo esc_attr($header_font_size); ?>px;
        }
    <?php endif ?>
</style> 

<div class="slider-wrapper" 
    data-slick='{"slidesToShow": <?php echo esc_attr( $slider_column) ?>,
     "slidesToScroll": 1, 
     "infinite": true, 
     "speed": 800, 
     "dots": false, 
     "arrows":true, 
     "autoplay": true, 
     "fade": false }'>
    <?php 
            $args = array (
                'post_type'     => 'post',
                'post_per_page' => count( $slider_post_posts ),
                'post__in'      => $slider_post_posts,
                'orderby'       =>'post__in', 
                'ignore_sticky_posts' => true, 
            ); 
       
        $loop = new WP_Query($args);                        
        if ( $loop->have_posts() ) :
            $i=0;  
            while ($loop->have_posts()) : $loop->the_post(); $i++;?>        
                <article>
                    <div class="slider-item-wrapper solid-border">
                        <?php if (has_post_thumbnail()) : ?>
                            <div class="post-featured-image">
                                <div class="featured-image" style="background-image: url('<?php the_post_thumbnail_url( 'blog-thumbnails');?>');">
                                    <a href="<?php the_permalink();?>" class="post-thumbnail-link"></a>                                    
                                </div><!-- .featured-image -->
                            </div>
                        <?php endif; ?>

                        <div class="entry-container <?php echo esc_attr($content_align); ?>">
                            <?php if ( ($slider_content_type !== 'slider_page') && ($enable_category==true) ) : ?>
                                <div class="entry-meta entry-cat">
                                    <?php iconic_blog_entry_meta(); ?>
                                </div><!-- .entry-meta -->
                            <?php endif; ?>
                            <header class="entry-header">
                                <h2 class="entry-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h2>
                            </header>
                            <?php if (($enable_posted_on==true) || ($enable_author==true)) : ?>
                                <div class="entry-meta">
                                    <?php 
                                        if (($enable_posted_on==true)) {
                                            iconic_blog_posted_on();
                                        } 
                                        if (($enable_author==true)) {
                                            iconic_blog_author();
                                        }
                                     ?>
                                </div><!-- .entry-meta -->
                            <?php endif; ?>
                            <?php if (($enable_content==true)) : ?>
                                <div class="entry-content">
                                    <?php 
                                        $excerpt = iconic_blog_the_excerpt( $excerpt_length );
                                        echo wp_kses_post( wpautop( $excerpt ) );
                                    ?>
                                </div><!-- .entry-content -->
                            <?php endif; ?>  
                        </div><!-- .entry-container -->
                    </div>
                </article>

            <?php endwhile;?>
        <?php endif; ?>
        <?php wp_reset_postdata(); ?>
</div>
