<?php
/**
 * Subtitle metabox file.
 *
 * @package Iconic Blog
 * @since Iconic Blog 1.0
 */

if ( ! function_exists( 'iconic_blog_video_url_callback' ) ) :
    /** 
     * Outputs the content of the Video Url
     */
    function iconic_blog_video_url_callback( $post ) {
        wp_nonce_field( basename( __FILE__ ), 'iconic_blog_nonce' );
        $video_url = get_post_meta( $post->ID, 'iconic-blog-video-url', true );
        ?>
        <p>
         <label for="iconic-blog-video-url" class="iconic-blog-row-title"><?php esc_html_e( 'Video Url', 'iconic-blog' )?></label>
         <input class="widefat" type="url" name="iconic-blog-video-url" id="iconic-blog-video-url" value="<?php echo esc_url( $video_url ); ?>"/>     
        </p>

        <?php
    }
endif;

if ( ! function_exists( 'iconic_blog_video_url_save' ) ) :
    /**
     * Saves the Video Url input
     */
    function iconic_blog_video_url_save( $post_id ) {
        // Checks save status
        $is_autosave = wp_is_post_autosave( $post_id );
        $is_revision = wp_is_post_revision( $post_id );
        $is_valid_nonce = ( isset( $_POST[ 'iconic_blog_nonce' ] ) && wp_verify_nonce( sanitize_key( $_POST[ 'iconic_blog_nonce' ] ), basename( __FILE__ ) ) ) ? 'true' : 'false';

        // Exits script depending on save status
        if ( $is_autosave || $is_revision || ! $is_valid_nonce ) {
            return;
        }

        // Checks for input and sanitizes/saves if needed
        if( isset( $_POST[ 'iconic-blog-video-url' ] ) ) {
            update_post_meta( $post_id, 'iconic-blog-video-url', sanitize_text_field( wp_unslash( $_POST[ 'iconic-blog-video-url' ] ) ) );
        }

    }
endif;
add_action( 'save_post', 'iconic_blog_video_url_save' );

