<?php
/**
 * Trending Post options.
 *
 * @package Iconic Blog
 */

$default = iconic_blog_get_default_theme_options();
$homepage_design_layout     = iconic_blog_get_option( 'homepage_design_layout_options' );

// Trending Post Section
$wp_customize->add_section( 'section_home_trending',
	array(
		'title'      => __( 'Trending Post Section', 'iconic-blog' ),
		'capability' => 'edit_theme_options',
		'panel'      => 'home_page_panel',
		)
);

$wp_customize->add_setting( 'theme_options[disable_trending_section]',
	array(
		'default'           => $default['disable_trending_section'],
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'iconic_blog_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Iconic_Blog_Switch_Control( $wp_customize, 'theme_options[disable_trending_section]',
    array(
		'label' 			=> __('Enable/Disable Trending Post Section', 'iconic-blog'),
		'section'    		=> 'section_home_trending',
		 'settings'  		=> 'theme_options[disable_trending_section]',
		'on_off_label' 		=> iconic_blog_switch_options(),
    )
) );

//Trending Post Section title
$wp_customize->add_setting('theme_options[trending_title]', 
	array(
	'default'           => $default['trending_title'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('theme_options[trending_title]', 
	array(
	'label'       => __('Section Title', 'iconic-blog'),
	'section'     => 'section_home_trending',   
	'settings'    => 'theme_options[trending_title]',
	'active_callback' => 'iconic_blog_trending_active',		
	'type'        => 'text'
	)
);

// Add arrow enable setting and control.
$wp_customize->add_setting( 'theme_options[trending_content_align]', array(
	'default'           => $default['trending_content_align'],
	'sanitize_callback' => 'iconic_blog_sanitize_select',
) );

$wp_customize->add_control( 'theme_options[trending_content_align]', array(
	'label'             => esc_html__( 'Choose Content Align', 'iconic-blog' ),
	'section'           => 'section_home_trending',
	'type'              => 'radio',
	'active_callback' => 'iconic_blog_trending_active',
	'choices'				=> array( 
		'content-right'     => esc_html__( 'Right Side', 'iconic-blog' ), 
		'content-center'     => esc_html__( 'Center Side', 'iconic-blog' ), 
		'content-left'     => esc_html__( 'Left Side', 'iconic-blog' ), 
		'content-justify'     => esc_html__( 'Justify', 'iconic-blog' )
		)
) );

// Add category enable setting and control.
$wp_customize->add_setting( 'theme_options[trending_category_enable]', array(
	'default'           => $default['trending_category_enable'],
	'sanitize_callback' => 'iconic_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[trending_category_enable]', array(
	'label'             => esc_html__( 'Enable Category', 'iconic-blog' ),
	'section'           => 'section_home_trending',
	'type'              => 'checkbox',
	'active_callback' => 'iconic_blog_trending_active',
) );	
// Add content enable setting and control.
$wp_customize->add_setting( 'theme_options[trending_content_enable]', array(
	'default'           => $default['trending_content_enable'],
	'sanitize_callback' => 'iconic_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[trending_content_enable]', array(
	'label'             => esc_html__( 'Enable Content', 'iconic-blog' ),
	'section'           => 'section_home_trending',
	'type'              => 'checkbox',
	'active_callback' => 'iconic_blog_trending_active',
) );

// Add posted on enable setting and control.
$wp_customize->add_setting( 'theme_options[trending_posted_on_enable]', array(
	'default'           => $default['trending_posted_on_enable'],
	'sanitize_callback' => 'iconic_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[trending_posted_on_enable]', array(
	'label'             => esc_html__( 'Enable Date', 'iconic-blog' ),
	'section'           => 'section_home_trending',
	'type'              => 'checkbox',
	'active_callback' => 'iconic_blog_trending_active',
) );

// Add posted on enable setting and control.
$wp_customize->add_setting( 'theme_options[trending_author_enable]', array(
	'default'           => $default['trending_author_enable'],
	'sanitize_callback' => 'iconic_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[trending_author_enable]', array(
	'label'             => esc_html__( 'Enable Author', 'iconic-blog' ),
	'section'           => 'section_home_trending',
	'type'              => 'checkbox',
	'active_callback' => 'iconic_blog_trending_active',
) );

// Add posted on enable setting and control.
$wp_customize->add_setting( 'theme_options[trending_views_enable]', array(
	'default'           => $default['trending_views_enable'],
	'sanitize_callback' => 'iconic_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[trending_views_enable]', array(
	'label'             => esc_html__( 'Enable Views', 'iconic-blog' ),
	'section'           => 'section_home_trending',
	'type'              => 'checkbox',
	'active_callback' => 'iconic_blog_trending_active',
) );

// Add posted on enable setting and control.
$wp_customize->add_setting( 'theme_options[trending_readtime_enable]', array(
	'default'           => $default['trending_readtime_enable'],
	'sanitize_callback' => 'iconic_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[trending_readtime_enable]', array(
	'label'             => esc_html__( 'Enable Read Time', 'iconic-blog' ),
	'section'           => 'section_home_trending',
	'type'              => 'checkbox',
	'active_callback' => 'iconic_blog_trending_active',
) );

// Setting  Team Category.
$wp_customize->add_setting( 'theme_options[trending_category]',
	array(

	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	new Iconic_Blog_Dropdown_Taxonomies_Control( $wp_customize, 'theme_options[trending_category]',
		array(
		'label'    => __( 'Select Category', 'iconic-blog' ),
		'section'  => 'section_home_trending',
		'settings' => 'theme_options[trending_category]',	
		'active_callback' => 'iconic_blog_trending_active',		
		)
	)
);

