<?php
/**
 * Subscription options.
 *
 * @package Iconic Blog
 */

$default = iconic_blog_get_default_theme_options();

// Blog & News Section
$wp_customize->add_section( 'section_home_subscription',
	array(
		'title'      => __( 'Subscription', 'iconic-blog' ),
		'capability' => 'edit_theme_options',
		'panel'      => 'home_page_panel',
		)
);

$wp_customize->add_setting( 'theme_options[disable_subscription_section]',
	array(
		'default'           => $default['disable_subscription_section'],
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'iconic_blog_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Iconic_Blog_Switch_Control( $wp_customize, 'theme_options[disable_subscription_section]',
    array(
		'label' 			=> __('Enable/Disable Subscription Section', 'iconic-blog'),
		'section'    		=> 'section_home_subscription',
		 'settings'  		=> 'theme_options[disable_subscription_section]',
		'on_off_label' 		=> iconic_blog_switch_options(),
    )
) );

//Blog & News Section title
$wp_customize->add_setting('theme_options[subscription_title]', 
	array(
	'default'           => $default['subscription_title'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('theme_options[subscription_title]', 
	array(
	'label'       => __('Section Title', 'iconic-blog'),
	'section'     => 'section_home_subscription',   
	'settings'    => 'theme_options[subscription_title]',
	'active_callback' => 'iconic_blog_subscription_active',		
	'type'        => 'text'
	)
);

//Recent Section title
$wp_customize->add_setting('theme_options[subscription_description]', 
	array(
	'default'           => $default['subscription_description'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('theme_options[subscription_description]', 
	array(
	'label'       => __('Section Desbscription', 'iconic-blog'),
	'section'     => 'section_home_subscription',   
	'settings'    => 'theme_options[subscription_description]',
	'active_callback' => 'iconic_blog_subscription_active',		
	'type'        => 'text'
	)
);

//Recent Section title
$wp_customize->add_setting('theme_options[subscription_bnt_text]', 
	array(
	'default'           => $default['subscription_bnt_text'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('theme_options[subscription_bnt_text]', 
	array(
	'label'       => __('Subscription Button Text', 'iconic-blog'),
	'section'     => 'section_home_subscription',   
	'settings'    => 'theme_options[subscription_bnt_text]',
	'active_callback' => 'iconic_blog_subscription_active',		
	'type'        => 'text'
	)
);


