<?php
/**
 * Slider Post options.
 *
 * @package Iconic Blog
 */

$default = iconic_blog_get_default_theme_options();
$homepage_design_layout     = iconic_blog_get_option( 'homepage_design_layout_options' );

// Slider Post Section
$wp_customize->add_section( 'section_home_slider',
	array(
		'title'      => __( 'Slider', 'iconic-blog' ),
		'capability' => 'edit_theme_options',
		'panel'      => 'home_page_panel',
		)
);

$wp_customize->add_setting( 'theme_options[disable_slider_section]',
	array(
		'default'           => $default['disable_slider_section'],
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'iconic_blog_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Iconic_Blog_Switch_Control( $wp_customize, 'theme_options[disable_slider_section]',
    array(
		'label' 			=> __('Enable/Disable Slider Post Section', 'iconic-blog'),
		'section'    		=> 'section_home_slider',
		 'settings'  		=> 'theme_options[disable_slider_section]',
		'on_off_label' 		=> iconic_blog_switch_options(),
    )
) );

// Add arrow enable setting and control.
$wp_customize->add_setting( 'theme_options[slider_content_align]', array(
	'default'           => $default['slider_content_align'],
	'sanitize_callback' => 'iconic_blog_sanitize_select',
) );

$wp_customize->add_control( 'theme_options[slider_content_align]', array(
	'label'             => esc_html__( 'Choose Content Align', 'iconic-blog' ),
	'section'           => 'section_home_slider',
	'type'              => 'radio',
	'active_callback' => 'iconic_blog_slider_active',
	'choices'				=> array( 
		'content-right'     => esc_html__( 'Right Side', 'iconic-blog' ), 
		'content-center'     => esc_html__( 'Center Side', 'iconic-blog' ), 
		'content-left'     => esc_html__( 'Left Side', 'iconic-blog' ), 
		'content-justify'     => esc_html__( 'Justify', 'iconic-blog' )
		)
) );

// Add category enable setting and control.
$wp_customize->add_setting( 'theme_options[slider_category_enable]', array(
	'default'           => $default['slider_category_enable'],
	'sanitize_callback' => 'iconic_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[slider_category_enable]', array(
	'label'             => esc_html__( 'Enable Category', 'iconic-blog' ),
	'section'           => 'section_home_slider',
	'type'              => 'checkbox',
	'active_callback' => 'iconic_blog_slider_active',
) );	
// Add content enable setting and control.
$wp_customize->add_setting( 'theme_options[slider_content_enable]', array(
	'default'           => $default['slider_content_enable'],
	'sanitize_callback' => 'iconic_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[slider_content_enable]', array(
	'label'             => esc_html__( 'Enable Content', 'iconic-blog' ),
	'section'           => 'section_home_slider',
	'type'              => 'checkbox',
	'active_callback' => 'iconic_blog_slider_active',
) );

// Add posted on enable setting and control.
$wp_customize->add_setting( 'theme_options[slider_posted_on_enable]', array(
	'default'           => $default['slider_posted_on_enable'],
	'sanitize_callback' => 'iconic_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[slider_posted_on_enable]', array(
	'label'             => esc_html__( 'Enable Date', 'iconic-blog' ),
	'section'           => 'section_home_slider',
	'type'              => 'checkbox',
	'active_callback' => 'iconic_blog_slider_active',
) );

// Add posted on enable setting and control.
$wp_customize->add_setting( 'theme_options[slider_author_enable]', array(
	'default'           => $default['slider_author_enable'],
	'sanitize_callback' => 'iconic_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[slider_author_enable]', array(
	'label'             => esc_html__( 'Enable Author', 'iconic-blog' ),
	'section'           => 'section_home_slider',
	'type'              => 'checkbox',
	'active_callback' => 'iconic_blog_slider_active',
) );

// Number of items
$wp_customize->add_setting('theme_options[slider_excerpt_length]', 
	array(
	'default' 			=> $default['slider_excerpt_length'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'iconic_blog_sanitize_number_range'
	)
);

$wp_customize->add_control('theme_options[slider_excerpt_length]', 
	array(
	'label'       => __('Excerpt Length', 'iconic-blog'),
	'description' => __('Save & Refresh the customizer to see its effect. Maximum is 1000.', 'iconic-blog'),
	'section'     => 'section_home_slider',   
	'settings'    => 'theme_options[slider_excerpt_length]',		
	'type'        => 'number',
	'active_callback' => 'iconic_blog_slider_active',
	'input_attrs' => array(
			'min'	=> 0,
			'max'	=> 1000,
			'step'	=> 1,
		),
	)
);


$number_of_slider_items = iconic_blog_get_option( 'number_of_slider_items' );

for( $i=1; $i<=$number_of_slider_items; $i++ ){

	//
	$wp_customize->add_setting('theme_options[slider_post_'.$i.']', 
		array(
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',	
		'sanitize_callback' => 'iconic_blog_dropdown_pages'
		)
	);

	$wp_customize->add_control('theme_options[slider_post_'.$i.']', 
		array(
		'label'       => sprintf( __('Select Post #%1$s', 'iconic-blog'), $i),
		'section'     => 'section_home_slider',   
		'settings'    => 'theme_options[slider_post_'.$i.']',		
		'type'        => 'select',
		'choices'	  => iconic_blog_post_choices(),
		'active_callback' => 'iconic_blog_slider_active',
		)
	);
}
