<?php
/**
 * Header options.
 *
 * @package Iconic Blog
 */

$default = iconic_blog_get_default_theme_options();

// Header Author Section
$wp_customize->add_section( 'section_home_header', 
	array(
		'title'      => __( 'Header Options', 'iconic-blog' ),
		'capability' => 'edit_theme_options',
		'panel'      => 'home_page_panel',
		)
);
// Add arrow enable setting and control.
$wp_customize->add_setting( 'theme_options[header_layout_options]', array(
	'default'           => $default['header_layout_options'],
	'sanitize_callback' => 'iconic_blog_sanitize_select',
	'type'				=> 'theme_mod',
) );

$wp_customize->add_control( 'theme_options[header_layout_options]', array(
	'label'             => esc_html__( 'Choose Header Layout', 'iconic-blog' ),
	'section'           => 'section_home_header',
	'type'              => 'radio',
	'choices'				=> array( 
		'header-one'     => esc_html__( 'Header One(Normal)', 'iconic-blog' ), 
		'header-two'     => esc_html__( 'Header Two(Blog Style)', 'iconic-blog' ), 
		)
) );

/** Social Enable Settings */
// Menu social links enable control and setting
$wp_customize->add_setting( 'theme_options[enable_menu_social_links]', array(
    'default'           =>  $default['enable_menu_social_links'],
    'sanitize_callback' => 'iconic_blog_sanitize_switch_control',
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',
) );

$wp_customize->add_control( new Iconic_Blog_Switch_Control( $wp_customize, 'theme_options[enable_menu_social_links]', array(
    'label'             => __( 'Enable Menu Social Links', 'iconic-blog' ),
    'section'           => 'section_home_header',
    'settings'         => 'theme_options[enable_menu_social_links]',
    'on_off_label'      => iconic_blog_switch_options(),
) ) );


for( $i=1; $i<=4; $i++ ){
	//Social Links
	$wp_customize->add_setting('theme_options[menu_social_link_'.$i.']', 
		array(
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',	
		'sanitize_callback' => 'esc_url_raw'
		)
	);

	$wp_customize->add_control('theme_options[menu_social_link_'.$i.']', 
		array(
		'label'       => sprintf( __('Social Link #%1$s', 'iconic-blog'), $i),
		'section'     => 'section_home_header',   
		'settings'    => 'theme_options[menu_social_link_'.$i.']',	
		'active_callback' => 'iconic_blog_header_one',		
		'type'        => 'url'
		)
	);
}
