<?php 
/**
 * List of posts for post choices.
 * @return Array Array of post ids and name.
 */
function iconic_blog_post_choices() {
    $posts = get_posts( array( 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'iconic-blog' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    return  $choices;
}

if ( ! function_exists( 'iconic_blog_switch_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function iconic_blog_switch_options() {
        $arr = array(
            'on'        => esc_html__( 'Enable', 'iconic-blog' ),
            'off'       => esc_html__( 'Disable', 'iconic-blog' )
        );
        return apply_filters( 'iconic_blog_switch_options', $arr );
    }
endif;

/**
 * List of category for category choices.
 * @return Array Array of post ids and name.
 */
function iconic_blog_category_choices() {
    $tax_args = array(
        'hierarchical' => 0,
        'taxonomy'     => 'category',
    );
    $taxonomies = get_categories( $tax_args );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'iconic-blog' );
    foreach ( $taxonomies as $tax ) {
        $choices[ $tax->term_id ] = $tax->name;
    }
    return  $choices;
}
if ( ! function_exists( 'iconic_blog_get_woo_product' ) ) {
    /**
     * Get product.
     */
    function iconic_blog_get_woo_product() {
        $args = array(
            'posts_per_page' => -1,
        );
         
        $choices = array( '' => esc_html__( '--Select--', 'iconic-blog' ) );
        $products = wc_get_products( $args );
        foreach ( $products as $product ) {
            $id = $product->get_id();
            $title = $product->get_name();
            $choices[ $id ] = $title;
        }
        return $choices;
    }
}




 /**
 * Get an array of google fonts.
 * 
 */
function iconic_blog_font_choices() {
    $font_family_arr = array();
    $font_family_arr[''] = esc_html__( '--Default--', 'iconic-blog' );

    // Make the request
    $request = wp_remote_get( get_theme_file_uri( 'assets/fonts/webfonts.json' ) );

    if( is_wp_error( $request ) ) {
        return false; // Bail early
    }
    // Retrieve the data
    $body = wp_remote_retrieve_body( $request );
    $data = json_decode( $body );
    if ( ! empty( $data ) ) {
        foreach ( $data->items as $items => $fonts ) {
            $family_str_arr = explode( ' ', $fonts->family );
            $family_value = implode( '-', array_map( 'strtolower', $family_str_arr ) );
            $font_family_arr[ $family_value ] = $fonts->family;
        }
    }

    return apply_filters( 'iconic_blog_font_choices', $font_family_arr );
}

if ( ! function_exists( 'iconic_blog_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function iconic_blog_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'iconic-blog' ),
            'header-font-1'   => esc_html__( 'Raleway', 'iconic-blog' ),
            'header-font-2'   => esc_html__( 'Poppins', 'iconic-blog' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'iconic-blog' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'iconic-blog' ),
            'header-font-5'   => esc_html__( 'Lato', 'iconic-blog' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'iconic-blog' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'iconic-blog' ),
            'header-font-8'   => esc_html__( 'Lora', 'iconic-blog' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'iconic-blog' ),
            'header-font-10'   => esc_html__( 'Muli', 'iconic-blog' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'iconic-blog' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'iconic-blog' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'iconic-blog' ),
            'header-font-14'   => esc_html__( 'Cairo', 'iconic-blog' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'iconic-blog' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'iconic-blog' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'iconic-blog' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'iconic-blog' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'iconic-blog' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'iconic-blog' ),
            'header-font-21'   => esc_html__( 'Courgette', 'iconic-blog' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'iconic-blog' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'iconic-blog' ),
            'header-font-24'   => esc_html__( 'Righteous', 'iconic-blog' ),
            'header-font-25'   => esc_html__( 'Dosis', 'iconic-blog' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'iconic-blog' ),
            'header-font-27'   => esc_html__( 'Faster one', 'iconic-blog' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'iconic-blog' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'iconic-blog' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'iconic-blog' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'iconic-blog' ),
        );

        $output = apply_filters( 'iconic_blog_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'iconic_blog_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function iconic_blog_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'iconic-blog' ),
            'body-font-1'     => esc_html__( 'Raleway', 'iconic-blog' ),
            'body-font-2'     => esc_html__( 'Poppins', 'iconic-blog' ),
            'body-font-3'     => esc_html__( 'Roboto', 'iconic-blog' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'iconic-blog' ),
            'body-font-5'     => esc_html__( 'Lato', 'iconic-blog' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'iconic-blog' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'iconic-blog' ),
            'body-font-8'   => esc_html__( 'Lora', 'iconic-blog' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'iconic-blog' ),
            'body-font-10'   => esc_html__( 'Muli', 'iconic-blog' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'iconic-blog' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'iconic-blog' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'iconic-blog' ),
            'body-font-14'   => esc_html__( 'Cairo', 'iconic-blog' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'iconic-blog' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'iconic-blog' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'iconic-blog' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'iconic-blog' ),
        );

        $output = apply_filters( 'iconic_blog_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;


if ( ! function_exists( 'iconic_blog_archive_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function iconic_blog_archive_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'iconic-blog' ),
            'header-font-1'   => esc_html__( 'Raleway', 'iconic-blog' ),
            'header-font-2'   => esc_html__( 'Poppins', 'iconic-blog' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'iconic-blog' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'iconic-blog' ),
            'header-font-5'   => esc_html__( 'Lato', 'iconic-blog' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'iconic-blog' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'iconic-blog' ),
            'header-font-8'   => esc_html__( 'Lora', 'iconic-blog' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'iconic-blog' ),
            'header-font-10'   => esc_html__( 'Muli', 'iconic-blog' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'iconic-blog' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'iconic-blog' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'iconic-blog' ),
            'header-font-14'   => esc_html__( 'Cairo', 'iconic-blog' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'iconic-blog' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'iconic-blog' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'iconic-blog' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'iconic-blog' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'iconic-blog' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'iconic-blog' ),
            'header-font-21'   => esc_html__( 'Courgette', 'iconic-blog' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'iconic-blog' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'iconic-blog' ),
            'header-font-24'   => esc_html__( 'Righteous', 'iconic-blog' ),
            'header-font-25'   => esc_html__( 'Dosis', 'iconic-blog' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'iconic-blog' ),
            'header-font-27'   => esc_html__( 'Faster one', 'iconic-blog' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'iconic-blog' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'iconic-blog' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'iconic-blog' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'iconic-blog' ),
        );

        $output = apply_filters( 'iconic_blog_archive_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'iconic_blog_archive_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function iconic_blog_archive_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'iconic-blog' ),
            'body-font-1'     => esc_html__( 'Raleway', 'iconic-blog' ),
            'body-font-2'     => esc_html__( 'Poppins', 'iconic-blog' ),
            'body-font-3'     => esc_html__( 'Roboto', 'iconic-blog' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'iconic-blog' ),
            'body-font-5'     => esc_html__( 'Lato', 'iconic-blog' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'iconic-blog' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'iconic-blog' ),
            'body-font-8'   => esc_html__( 'Lora', 'iconic-blog' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'iconic-blog' ),
            'body-font-10'   => esc_html__( 'Muli', 'iconic-blog' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'iconic-blog' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'iconic-blog' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'iconic-blog' ),
            'body-font-14'   => esc_html__( 'Cairo', 'iconic-blog' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'iconic-blog' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'iconic-blog' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'iconic-blog' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'iconic-blog' ),
        );

        $output = apply_filters( 'iconic_blog_archive_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'iconic_blog_page_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function iconic_blog_page_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'iconic-blog' ),
            'header-font-1'   => esc_html__( 'Raleway', 'iconic-blog' ),
            'header-font-2'   => esc_html__( 'Poppins', 'iconic-blog' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'iconic-blog' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'iconic-blog' ),
            'header-font-5'   => esc_html__( 'Lato', 'iconic-blog' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'iconic-blog' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'iconic-blog' ),
            'header-font-8'   => esc_html__( 'Lora', 'iconic-blog' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'iconic-blog' ),
            'header-font-10'   => esc_html__( 'Muli', 'iconic-blog' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'iconic-blog' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'iconic-blog' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'iconic-blog' ),
            'header-font-14'   => esc_html__( 'Cairo', 'iconic-blog' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'iconic-blog' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'iconic-blog' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'iconic-blog' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'iconic-blog' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'iconic-blog' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'iconic-blog' ),
            'header-font-21'   => esc_html__( 'Courgette', 'iconic-blog' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'iconic-blog' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'iconic-blog' ),
            'header-font-24'   => esc_html__( 'Righteous', 'iconic-blog' ),
            'header-font-25'   => esc_html__( 'Dosis', 'iconic-blog' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'iconic-blog' ),
            'header-font-27'   => esc_html__( 'Faster one', 'iconic-blog' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'iconic-blog' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'iconic-blog' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'iconic-blog' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'iconic-blog' ),
        );

        $output = apply_filters( 'iconic_blog_page_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'iconic_blog_page_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function iconic_blog_page_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'iconic-blog' ),
            'body-font-1'     => esc_html__( 'Raleway', 'iconic-blog' ),
            'body-font-2'     => esc_html__( 'Poppins', 'iconic-blog' ),
            'body-font-3'     => esc_html__( 'Roboto', 'iconic-blog' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'iconic-blog' ),
            'body-font-5'     => esc_html__( 'Lato', 'iconic-blog' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'iconic-blog' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'iconic-blog' ),
            'body-font-8'   => esc_html__( 'Lora', 'iconic-blog' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'iconic-blog' ),
            'body-font-10'   => esc_html__( 'Muli', 'iconic-blog' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'iconic-blog' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'iconic-blog' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'iconic-blog' ),
            'body-font-14'   => esc_html__( 'Cairo', 'iconic-blog' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'iconic-blog' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'iconic-blog' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'iconic-blog' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'iconic-blog' ),
        );

        $output = apply_filters( 'iconic_blog_page_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'iconic_blog_post_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function iconic_blog_post_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'iconic-blog' ),
            'header-font-1'   => esc_html__( 'Raleway', 'iconic-blog' ),
            'header-font-2'   => esc_html__( 'Poppins', 'iconic-blog' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'iconic-blog' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'iconic-blog' ),
            'header-font-5'   => esc_html__( 'Lato', 'iconic-blog' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'iconic-blog' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'iconic-blog' ),
            'header-font-8'   => esc_html__( 'Lora', 'iconic-blog' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'iconic-blog' ),
            'header-font-10'   => esc_html__( 'Muli', 'iconic-blog' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'iconic-blog' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'iconic-blog' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'iconic-blog' ),
            'header-font-14'   => esc_html__( 'Cairo', 'iconic-blog' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'iconic-blog' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'iconic-blog' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'iconic-blog' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'iconic-blog' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'iconic-blog' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'iconic-blog' ),
            'header-font-21'   => esc_html__( 'Courgette', 'iconic-blog' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'iconic-blog' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'iconic-blog' ),
            'header-font-24'   => esc_html__( 'Righteous', 'iconic-blog' ),
            'header-font-25'   => esc_html__( 'Dosis', 'iconic-blog' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'iconic-blog' ),
            'header-font-27'   => esc_html__( 'Faster one', 'iconic-blog' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'iconic-blog' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'iconic-blog' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'iconic-blog' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'iconic-blog' ),
        );

        $output = apply_filters( 'iconic_blog_post_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'iconic_blog_post_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function iconic_blog_post_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'iconic-blog' ),
            'body-font-1'     => esc_html__( 'Raleway', 'iconic-blog' ),
            'body-font-2'     => esc_html__( 'Poppins', 'iconic-blog' ),
            'body-font-3'     => esc_html__( 'Roboto', 'iconic-blog' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'iconic-blog' ),
            'body-font-5'     => esc_html__( 'Lato', 'iconic-blog' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'iconic-blog' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'iconic-blog' ),
            'body-font-8'   => esc_html__( 'Lora', 'iconic-blog' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'iconic-blog' ),
            'body-font-10'   => esc_html__( 'Muli', 'iconic-blog' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'iconic-blog' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'iconic-blog' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'iconic-blog' ),
            'body-font-14'   => esc_html__( 'Cairo', 'iconic-blog' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'iconic-blog' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'iconic-blog' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'iconic-blog' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'iconic-blog' ),
        );

        $output = apply_filters( 'iconic_blog_post_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;


if ( ! function_exists( 'iconic_blog_site_title_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function iconic_blog_site_title_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'iconic-blog' ),
            'site-font-1'   => esc_html__( 'Raleway', 'iconic-blog' ),
            'site-font-2'   => esc_html__( 'Poppins', 'iconic-blog' ),
            'site-font-3'   => esc_html__( 'Montserrat', 'iconic-blog' ),
            'site-font-4'   => esc_html__( 'Open Sans', 'iconic-blog' ),
            'site-font-5'   => esc_html__( 'Lato', 'iconic-blog' ),
            'site-font-6'   => esc_html__( 'Ubuntu', 'iconic-blog' ),
            'site-font-7'   => esc_html__( 'Playfair Display', 'iconic-blog' ),
            'site-font-8'   => esc_html__( 'Lora', 'iconic-blog' ),
            'site-font-9'   => esc_html__( 'Titillium Web', 'iconic-blog' ),
            'site-font-10'   => esc_html__( 'Muli', 'iconic-blog' ),
            'site-font-11'   => esc_html__( 'Oxygen', 'iconic-blog' ),
            'site-font-12'   => esc_html__( 'Nunito Sans', 'iconic-blog' ),
            'site-font-13'   => esc_html__( 'Maven Pro', 'iconic-blog' ),
            'site-font-14'   => esc_html__( 'Cairo', 'iconic-blog' ),
            'site-font-15'   => esc_html__( 'Philosopher', 'iconic-blog' ),
            'site-font-16'   => esc_html__( 'Quicksand', 'iconic-blog' ),
            'site-font-17'   => esc_html__( 'Henny Penny', 'iconic-blog' ),
            'site-font-18'   => esc_html__( 'Orbitron' , 'iconic-blog' ),
            'site-font-19'   => esc_html__( 'Marck Script', 'iconic-blog' ),
            'site-font-20'   => esc_html__( 'Kaushan Script', 'iconic-blog' ),
            'site-font-21'   => esc_html__( 'Courgette', 'iconic-blog' ),
            'site-font-22'   => esc_html__( 'Rajdhani', 'iconic-blog' ),
            'site-font-23'   => esc_html__( 'Bad Script', 'iconic-blog' ),
            'site-font-24'   => esc_html__( 'Righteous', 'iconic-blog' ),
            'site-font-25'   => esc_html__( 'Dosis', 'iconic-blog' ),
            'site-font-26'   => esc_html__( 'Cinzel Decorative', 'iconic-blog' ),
            'site-font-27'   => esc_html__( 'Faster one', 'iconic-blog' ),
            'site-font-28'   => esc_html__( 'Tangerine', 'iconic-blog' ),
            'site-font-29'   => esc_html__( 'Fredericka the Great', 'iconic-blog' ),
            'site-font-30'   => esc_html__( 'Shadows Into Light', 'iconic-blog' ),
            'site-font-31'   => esc_html__( 'Gloria Hallelujah', 'iconic-blog' ),
        );

        $output = apply_filters( 'iconic_blog_site_title_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'iconic_blog_site_tagline_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function iconic_blog_site_tagline_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'iconic-blog' ),
            'tagline-font-1'     => esc_html__( 'Raleway', 'iconic-blog' ),
            'tagline-font-2'     => esc_html__( 'Poppins', 'iconic-blog' ),
            'tagline-font-3'     => esc_html__( 'Roboto', 'iconic-blog' ),
            'tagline-font-4'     => esc_html__( 'Open Sans', 'iconic-blog' ),
            'tagline-font-5'     => esc_html__( 'Lato', 'iconic-blog' ),
            'tagline-font-6'   => esc_html__( 'Ubuntu', 'iconic-blog' ),
            'tagline-font-7'   => esc_html__( 'Playfair Display', 'iconic-blog' ),
            'tagline-font-8'   => esc_html__( 'Lora', 'iconic-blog' ),
            'tagline-font-9'   => esc_html__( 'Titillium Web', 'iconic-blog' ),
            'tagline-font-10'   => esc_html__( 'Muli', 'iconic-blog' ),
            'tagline-font-11'   => esc_html__( 'Oxygen', 'iconic-blog' ),
            'tagline-font-12'   => esc_html__( 'Nunito Sans', 'iconic-blog' ),
            'tagline-font-13'   => esc_html__( 'Maven Pro', 'iconic-blog' ),
            'tagline-font-14'   => esc_html__( 'Cairo', 'iconic-blog' ),
            'tagline-font-15'   => esc_html__( 'Philosopher', 'iconic-blog' ),
            'tagline-font-16'   => esc_html__( 'Quicksand', 'iconic-blog' ),
            'tagline-font-17'   => esc_html__( 'Dancing Script ', 'iconic-blog' ),
            'tagline-font-18'   => esc_html__( 'Rajdhani', 'iconic-blog' ),
        );

        $output = apply_filters( 'iconic_blog_site_tagline_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

 ?>