<?php
/**
 * Default theme options.
 *
 * @package Iconic Blog
 */


if ( ! function_exists( 'iconic_blog_get_default_theme_options' ) ) :

	/**
	 * Get default theme options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
	
	function iconic_blog_get_default_theme_options() {

		$theme_data = wp_get_theme();
		$defaults = array();

		$defaults['show_header_contact_info'] 	= true;
		$defaults['disable_homepage_content_section'] 			= false;
		$defaults['show_topbar'] 			= true;
		$defaults['topbar_layout_option'] 			= 'contact-info-option';
	    $defaults['header_email']             	= __( 'info@sensationaltheme.com','iconic-blog' );
	    $defaults['header_phone' ]            	= __( '+1-541-754-3010','iconic-blog' );
	    $defaults['header_location' ]           = __( 'London, UK','iconic-blog' );
	    $defaults['enable_header_contact_info'] 	= true;
	    $defaults['header_email_text']             	= __( 'Email ID','iconic-blog' );
	    $defaults['header_phone_text' ]            	= __( 'Free Call','iconic-blog' );
	    $defaults['header_location_text' ]           = __( 'Visit Us','iconic-blog' );
	    $defaults['header_email_address']             	= __( 'info@sensationaltheme.com','iconic-blog' );
	    $defaults['header_phone_contact' ]            	= __( '+1-541-754-3010','iconic-blog' );
	    $defaults['header_location_address' ]           = __( 'London, UK','iconic-blog' );
	    $defaults['show_header_social_links'] 	= true;
	    $defaults['show_menu_social_links'] 	= true;
	    $defaults['header_social_links']		= array();
	    $defaults['disable_header_background_section'] = false;
	    $defaults['show_header_search'] 	= true;
	    $defaults['show_current_date'] 	= true;
	    $defaults['top_login_text'] 	= __( 'Login','iconic-blog' );
	    $defaults['top_login_url'] 	='#';
	    $defaults['top_register_text'] 	= __( 'Register','iconic-blog' );
	    $defaults['top_register_url'] 	= '#';
	    $defaults['search_login_layout'] 	= 'login-option';
	    $defaults['colorscheme_hue'] 	= '#6B6A6A';
	    $defaults['medi_text_color'] 	= '#191B1D';
	    $defaults['medi_secondary_color'] 	= '#14457B';
	    $defaults['topbar_background_color'] 	= '#000';
	    $defaults['topbar_color'] 	= '#ffffff';
	    $defaults['enable_center_logo'] 	= true;
	    $defaults['enable_menu_social_links'] 	= false;
	    $defaults['menu_bg_color']   = '#6B6A6A';


	    $defaults['menu_background_color'] 	= '#f7e1b4';
	    $defaults['menu_text_hover'] 	= 'menu-hover-none';
	    $defaults['header_text_hover'] 	= 'title-hover-none';
	    $defaults['number_of_menu_items'] 	= 6;
	    $defaults['preloader_loader_enable'] 	= false;
	    $defaults['preloader_loader_options'] 	= 'loader-1';
	    $defaults['header_text_transform_options'] 	= 'none';
	    $defaults['header_text_decoration_options'] 	= 'none';
	    $defaults['header_font_style_options'] 	= 'none';
	    $defaults['header_text_design'] 	= false;
	    $defaults['homepage_color_layout_options']			= 'lite-layout';
	    $defaults['header_layout_options']			= 'header-one';
	    $defaults['homepage_design_layout_options']			= 'home-main';
	    $defaults['homepage_sidebar_position']			= 'home-right-sidebar';
	    $defaults['header_top_buttom_padding']			= 10;

	    //Slider Section
		$defaults['disable_slider_section']	= false;
		$defaults['slider_title']	   	 		= esc_html__( 'Explore latest slider articles', 'iconic-blog' );
		$defaults['slider_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'iconic-blog' );
		$defaults['slider_see_all_txt']			= esc_html__( 'See All', 'iconic-blog' );
		$defaults['number_of_slider_items']			= 6;
		$defaults['number_of_slider_column']			= 1;
		$defaults['slider_excerpt_length']			= 10;
		$defaults['slider_content_type']			= 'slider_category';
		$defaults['slider_content_align']			= 'content-left';
		$defaults['slider_background_color']			= '#F7A839';
		$defaults['slider_category_enable']		= false;
		$defaults['slider_posted_on_enable']		= true;
		$defaults['slider_author_enable']		= false;
		$defaults['slider_content_enable']		= false;

	    // Catlist Category Section
		$defaults['disable_catlist_section']	= false;
		$defaults['number_of_catlist_column']			= 7;
		$defaults['number_of_catlist_items']			= 10;
		$defaults['catlist_content_type']			= 'post-category';
		$defaults['catlist_title']	   	 		= esc_html__( 'My Major Category', 'iconic-blog' );
		$defaults['catlist_subtitle']	   	 		= esc_html__( 'I love natural beauty, and I think it’s your best look, but I think makeup as an artist is so transformative.', 'iconic-blog' );

		//Video Section
		$defaults['disable_video_section']	= true;
		$defaults['video_title']	   	 		= esc_html__( 'Explore latest video articles', 'iconic-blog' );
		$defaults['video_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'iconic-blog' );
		$defaults['video_see_all_txt']			= esc_html__( 'See All', 'iconic-blog' );
		$defaults['number_of_video_items']			= 6;
		$defaults['number_of_video_column']			= 4;
		$defaults['video_excerpt_length']			= 10;
		$defaults['video_content_type']			= 'video_category';
		$defaults['video_content_align']			= 'content-left';
		$defaults['video_background_color']			= '#F7A839';
		$defaults['video_category_enable']		= false;
		$defaults['video_posted_on_enable']		= true;
		$defaults['video_author_enable']		= false;
		$defaults['video_content_enable']		= false;
		$defaults['number_of_video_ads']			= 2;
		$defaults['video_column_option']			= 'col-2';
		$defaults['disable_video_ads_section']	= false;

		// Featured Post Section
		$defaults['disable_featuredpost_section']	= true;
		$defaults['featuredpost_title']	   	 	= esc_html__( 'Your Ultimate Destination Guide', 'iconic-blog' );
		$defaults['featuredpost_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'iconic-blog' );
		$defaults['featuredpost_right_title']	   	 	= esc_html__( 'Featured Post', 'iconic-blog' );
		$defaults['number_of_featuredpost_items']			= 9;
		$defaults['featuredpost_excerpt_length']			= 5;
		$defaults['featuredpost_layout_option']			= 'default-featuredpost';
		$defaults['featuredpost_content_type']			= 'featuredpost_category';
		$defaults['featuredpost_lite_dark_background']	= 'lite-bg';
		$defaults['featuredpost_category_enable']		= true;
		$defaults['featuredpost_posted_on_enable']		= true;
		$defaults['featuredpost_content_enable']		= false;
		$defaults['featuredpost_author_enable']		= true;
		$defaults['featuredpost_post_count_enable']		= false;
		$defaults['featuredpost_see_all_txt']			= esc_html__( 'See All', 'iconic-blog' );
		$defaults['number_of_featuredpost_ads']			= 2;
		$defaults['featuredpost_column_option']			= 'col-2';
		$defaults['disable_featuredpost_ads_section']	= false;

		//Must Read Section
		$defaults['disable_mustread_section']	= false;
		$defaults['mustread_title']	   	 		= esc_html__( 'Top Stories You Need to See', 'iconic-blog' );
		$defaults['mustread_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'iconic-blog' );
		$defaults['mustread_see_all_txt']			= esc_html__( 'See All', 'iconic-blog' );
		$defaults['number_of_mustread_items']			= 4;
		$defaults['number_of_mustread_column']			= 4;
		$defaults['mustread_excerpt_length']			= 20;
		$defaults['mustread_content_type']			= 'mustread_category';
		$defaults['mustread_content_align']			= 'content-left';
		$defaults['mustread_background_color']			= '#F7A839';
		$defaults['mustread_category_enable']		= true;
		$defaults['mustread_posted_on_enable']		= true;
		$defaults['mustread_author_enable']		= true;
		$defaults['mustread_content_enable']		= false;
		$defaults['mustread_see_all_txt']			= esc_html__( 'See All', 'iconic-blog' );
		$defaults['number_of_mustread_ads']			= 2;
		$defaults['mustread_column_option']			= 'col-2';
		$defaults['disable_mustread_ads_section']	= false;


		//Popular Section
		$defaults['disable_popular_section']	= true;
		$defaults['popular_title']	   	 		= esc_html__( 'The Most Loved Stories', 'iconic-blog' );
		$defaults['popular_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'iconic-blog' );
		$defaults['popular_see_all_txt']			= esc_html__( 'See All', 'iconic-blog' );
		$defaults['number_of_popular_items']			= 10;
		$defaults['number_of_popular_column']			= 5;
		$defaults['popular_excerpt_length']			= 20;
		$defaults['popular_content_type']			= 'popular_category';
		$defaults['popular_content_align']			= 'content-left';
		$defaults['popular_background_color']			= '#fff';
		$defaults['popular_category_enable']		= true;
		$defaults['popular_posted_on_enable']		= true;
		$defaults['popular_author_enable']		= true;
		$defaults['popular_content_enable']		= false;
		$defaults['popular_post_count_enable']		= false;
		$defaults['number_of_popular_ads']			= 1;
		$defaults['popular_column_option']			= 'col-1';
		$defaults['disable_popular_ads_section']	= false;


		//Popular Section
		$defaults['disable_fixheight_section']	= true;
		$defaults['fixheight_title']	   	 		= esc_html__( 'Discover the Beauty of Destination', 'iconic-blog' );
		$defaults['fixheight_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'iconic-blog' );
		$defaults['number_of_fixheight_items']			= 10;
		$defaults['number_of_fixheight_column']			= 3;
		$defaults['fixheight_excerpt_length']			= 20;
		$defaults['fixheight_right_content_type']			= 'fixheight_right_post';
		$defaults['fixheight_right_excerpt_length']			= 20;
		$defaults['fixheight_content_type']			= 'fixheight_category';
		$defaults['fixheight_content_align']			= 'content-left';
		$defaults['fixheight_background_color']			= '#fff';
		$defaults['fixheight_see_all_txt']			= esc_html__( 'See All', 'iconic-blog' );
		$defaults['fixheight_right_category_enable']		= true;
		$defaults['fixheight_right_posted_on_enable']		= true;
		$defaults['fixheight_right_author_enable']		= true;
		$defaults['fixheight_right_content_enable']		= false;
		$defaults['fixheight_category_enable']		= false;
		$defaults['fixheight_posted_on_enable']		= true;
		$defaults['fixheight_author_enable']		= false;
		$defaults['fixheight_content_enable']		= true;
		$defaults['fixheight_post_count_enable']		= false;
		$defaults['number_of_fixheight_ads']			= 1;
		$defaults['fixheight_column_option']			= 'col-1';
		$defaults['disable_fixheight_ads_section']	= false;

		//Trending Section
		$defaults['disable_trending_section']	= false;
		$defaults['trending_title']	   	 		= esc_html__( 'Whats Hot Right Now', 'iconic-blog' );
		$defaults['trending_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'iconic-blog' );
		$defaults['number_of_trending_items']			= 6;
		$defaults['number_of_trending_column']			= 3;
		$defaults['trending_excerpt_length']			= 20;
		$defaults['trending_content_type']			= 'trending_category';
		$defaults['trending_content_align']			= 'content-left';
		$defaults['trending_background_color']			= '#fff';
		$defaults['trending_category_enable']		= true;
		$defaults['trending_posted_on_enable']		= true;
		$defaults['trending_author_enable']		= true;
		$defaults['trending_content_enable']		= true;
		$defaults['trending_views_enable']		= true;
		$defaults['trending_readtime_enable']		= true;
		$defaults['trending_see_all_txt']			= esc_html__( 'See All', 'iconic-blog' );

		// Shop product Section
		$defaults['disable_shopproduct_section']	= true;
		$defaults['shopproduct_title']	   	 		= esc_html__( 'Product', 'iconic-blog' );
		$defaults['shopproduct_readmore']	   	 		= esc_html__( 'Boy Now', 'iconic-blog' );
		$defaults['shopproduct_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'iconic-blog' );
		$defaults['number_of_shopproduct_items']	= 2;
		$defaults['shopproduct_content_type']		= 'product';
		$defaults['shopproduct_background_color']	   	= '#fff';

		// Gallery Section
		$defaults['disable_subscription_section']	= true;
		;$defaults['subscription_title']	   				= esc_html__( 'Subscribe To Our Postletter', 'iconic-blog' );
		$defaults['subscription_description']	   	 		= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'iconic-blog' );
		$defaults['subscription_bnt_text']	   	 		= esc_html__( 'Subscribe', 'iconic-blog' );

		// Banner Section
		$defaults['disable_banner_section']	= false;
		$defaults['banner_title']	   	 		= esc_html__( 'Whats Hot Right Now', 'iconic-blog' );
		$defaults['banner_subtitle']	   	 	= esc_html__( 'Every sunrise brings a new opportunity to rewrite your story, to chase your dreams, and to embrace the magic of possibilities.', 'iconic-blog' );
		$defaults['number_of_banner_items']			= 4;
		$defaults['number_of_banner_column']			= 4;
		$defaults['banner_excerpt_length']			= 20;
		$defaults['banner_content_type']			= 'banner_category';
		$defaults['banner_content_align']			= 'content-left';
		$defaults['banner_background_color']			= '#fff';
		$defaults['banner_category_enable']		= true;
		$defaults['banner_posted_on_enable']		= false;
		$defaults['banner_author_enable']		= false;
		$defaults['banner_content_enable']		= false;
		$defaults['banner_views_enable']		= true;
		$defaults['banner_readtime_enable']		= true;
		$defaults['banner_see_all_txt']			= esc_html__( 'See All', 'iconic-blog' );

		// Instagram Section
		$defaults['disable_instagram_section']	= false;
		$defaults['instagram_title']	   	 	= esc_html__( 'Instagram', 'iconic-blog' );

		// Latest Post Section
		$defaults['latest_posts_title']	   	 	= esc_html__( 'Latest Post', 'iconic-blog' );
		$defaults['number_of_latest_posts_column']	= 2;
		$defaults['pagination_type']		= 'numeric';
		$defaults['latest_category_enable']		= true;
		$defaults['latest_author_enable']		= true;
		$defaults['latest_comment_enable']		= true;
		$defaults['latest_content_enable']		= true;
		$defaults['latest_read_more_text_enable']		= true;
		$defaults['latest_posted_on_enable']		= true;
		$defaults['latest_video_enable']		= false;
		$defaults['blog_layout_content_type']		= 'blog-one';
		$defaults['archive_content_align']		= 'content-left';
		$defaults['archive_post_header_title_enable']		= true;
		$defaults['archive_post_header_image_enable']		= true;
		$defaults['remove_category_text_archive_page']		= true;
		$defaults['blog_post_header_image_enable']		= true;
		$defaults['blog_post_header_title_enable']		= true;
		$defaults['background_image_enable']		= true;
		
		// Decoration Option
		$defaults['decoration_side_enable']		= true;
		

		// Category Design Option
		$defaults['category_design_content_type']		= 'category-two';
		$defaults['enable_category_icon']		= false;

		// Single Post Option
		$defaults['single_post_category_enable']		= true;
		$defaults['single_post_posted_on_enable']		= true;
		$defaults['single_post_video_enable']		= true;
		$defaults['single_post_comment_enable']		= true;
		$defaults['single_post_author_enable']		= true;
		$defaults['single_post_pagination_enable']		= true;
		$defaults['single_post_image_enable']		= true;
		$defaults['single_post_header_image_enable']		= true;
		$defaults['single_post_header_title_enable']		= true;
		$defaults['single_post_header_image_as_header_image_enable']		= true;
		$defaults['iconic_blog_single_related_posts']		= true;
		$defaults['single_post_content_align']		= 'content-left';
		$defaults['iconic_blog_single_related_post_title']		= esc_html__( 'Related Posts', 'iconic-blog' );


		// Single Post Option
		$defaults['single_page_video_enable']		= true;
		$defaults['single_page_image_enable']		= true;
		$defaults['single_page_header_image_enable']		= true;
		$defaults['single_page_header_title_enable']		= true;
		$defaults['single_page_header_image_as_header_image_enable']		= true;
		$defaults['single_page_content_align']		= 'content-left';
		
		$defaults['theme_typography']			=  'default';
		$defaults['body_theme_typography']		=  'default';		
		$defaults['archive_typography']			=  'default';
		$defaults['body_archive_typography']		=  'default';		
		$defaults['page_typography']			=  'default';
		$defaults['body_page_typography']		=  'default';		
		$defaults['post_typography']			=  'default';
		$defaults['body_post_typography']		=  'default';		
		$defaults['site_title_typography']			=  'default';
		$defaults['site_tagline_typography']		=  'default';

		// animation
		$defaults['animation_slide_type']		= 'animation-b-t';
		$defaults['enable_animation']		= false;

		//Site Layout
		$defaults['site_layout_theme_options']			= 'default-site-layout';
		
		//General Section
		$defaults['latest_readmore_text']			= esc_html__('Read More','iconic-blog');
		$defaults['excerpt_length']					= 30;
		$defaults['layout_options_blog']			= 'right-sidebar';
		$defaults['layout_options_archive']			= 'right-sidebar';
		$defaults['layout_options_page']			= 'right-sidebar';	
		$defaults['layout_options_single']			= 'right-sidebar';	

		//Footer section 
		$defaults['scroll_top_visible']		= true;		
		$defaults['copyright_text']				= esc_html__( 'Copyright &copy; All rights reserved.', 'iconic-blog' );
		$defaults['powered_by_text']			= esc_html__( 'Iconic Blog by Sensational Theme', 'iconic-blog' );
		$defaults['enable_footer_background_image'] 	= true;
		$defaults['footer_copyright_font_color'] 	= '#fff';
		$defaults['footer_copyright_background_color'] 	= '#000';

		// Pass through filter.
		$defaults = apply_filters( 'iconic_blog_filter_default_theme_options', $defaults );
		return $defaults;
	}

endif;


/**
*  Get theme options
*/
if ( ! function_exists( 'iconic_blog_get_option' ) ) :

	/**
	 * Get theme option
	 *
	 * @since 1.0.0
	 *
	 * @param string $key Option key.
	 * @return mixed Option value.
	 */
	function iconic_blog_get_option( $key ) {

			$default_options = iconic_blog_get_default_theme_options();
		
		if ( empty( $key ) ) {
			return;
		}

		$theme_options = (array)get_theme_mod( 'theme_options' );
		$theme_options = wp_parse_args( $theme_options, $default_options );

		$value = null;

		if ( isset( $theme_options[ $key ] ) ) {
			$value = $theme_options[ $key ];
		}

		return $value;

	}

endif;