<?php
/**
 * Functions for Ello Photographer Portfolio Child Theme
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

 function ello_photographer_services_child_theme_setup() {
    // Add support for the title tag
    add_theme_support( 'title-tag' );

    // Add support for automatic feed links
    add_theme_support( 'automatic-feed-links' );
}
add_action( 'after_setup_theme', 'ello_photographer_services_child_theme_setup' );

function ello_photographer_services_child_theme_widgets_init() {
    register_sidebar( array(
       'name'          => esc_html__( 'Sidebar', 'ello-photographer-services' ),
        'id'            => 'sidebar-1',
        'description'   => esc_html__( 'Add widgets here.', 'ello-photographer-services' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );
}
add_action( 'widgets_init', 'ello_photographer_services_child_theme_widgets_init' );


/**
 * Enqueue parent and child theme styles, and custom parent CSS
 */
function ello_photographer_services_enqueue_styles() {
    // Enqueue parent style
    wp_enqueue_style(
        'ello-parent-style',
        get_template_directory_uri() . '/style.css'
    );
    wp_enqueue_script(
        'ello-child-main-script',                                    
        get_stylesheet_directory_uri() . '/js/screipt.js',   
        array(),                                                    
        '1.0.0',                                                    
        true                                                       
    );
}
add_action( 'wp_enqueue_scripts', 'ello_photographer_services_enqueue_styles' );

function ello_photographer_services_remove_parent_theme_settings($wp_customize) {
    $wp_customize->remove_control('theme_info_theme');
}
add_action('customize_register', 'ello_photographer_services_remove_parent_theme_settings', 20);


// Customizer settings for the child theme
function ello_photographer_services_child_register_additional_customizer_settings( $wp_customize ) {
    // Add your customizer settings here
    $wp_customize->add_section( 'theme_info', array(
        'title'       => __( 'Demo & Documentation', 'ello-photographer-services' ),
        'priority'    => 6,
    ) );

    /** Important Links */
    $wp_customize->add_setting( 'theme_info_theme_child',
        array(
            'default' => '',
            'sanitize_callback' => 'wp_kses_post',
        )
    );
    
   	$theme_info = '';
	$theme_info .= sprintf( '<p>' . __( 'Pro Demo Link: %1$sClick here.%2$s', 'ello-photographer-services' ) . '</p>', '<a href="' . esc_url( 'https://pixelonetry.com/previews/?theme=ello' ) . '" target="_blank">', '</a>' );
	$theme_info .= sprintf( '<p>' . __( 'Documentation: %1$sClick here.%2$s', 'ello-photographer-services' ) . '</p>', '<a href="' . esc_url( 'https://pixelonetry.com/docs/spirallite/' ) . '" target="_blank">', '</a>' );
	$theme_info .= sprintf( '<p>' . __( 'Video Tutorial: %1$sClick here.%2$s', 'ello-photographer-services' ) . '</p>', '<a href="' . esc_url( 'https://www.youtube.com/watch?v=NVbuDPmXuaU' ) . '" target="_blank">', '</a>' );
	$theme_info .= sprintf( '<p>' . __( 'Rate The Theme: %1$sClick here.%2$s', 'ello-photographer-services' ) . '</p>', '<a href="' . esc_url( 'https://wordpress.org/support/theme/ello-lite-photography/reviews/#new-post' ) . '" target="_blank">', '</a>' );
	$theme_info .= sprintf( '<p>' . __( 'Submit Ticket: %1$sClick here.%2$s', 'ello-photographer-services' ) . '</p>', '<a href="' . esc_url( 'https://pixelonetry.freshdesk.com/support/tickets/new' ) . '" target="_blank">', '</a>' );

    
    $wp_customize->add_control( new WP_Customize_Control( $wp_customize,
        'theme_info_theme_child',
        array(
            'section'     => 'theme_info',
            'description' => $theme_info,
            'type'        => 'hidden',
        )
    ));
}
add_action( 'customize_register', 'ello_photographer_services_child_register_additional_customizer_settings' );


/**
 * Admin Notice for Spiral Lite One Page Theme (Child Theme)
 */

function ello_photographer_services_child_theme_remove_parent_admin_notice() {
    remove_action('admin_notices', 'ello_lite_photography_admin_notice');
}

add_action('init', 'ello_photographer_services_child_theme_remove_parent_admin_notice'); // Remove the parent theme's notice

function ello_photographer_services_child_admin_notice() {			
    echo '<div class="service_section">
    </div><br/><a href="https://pixelonetry.com/downloads/ello-lite-photography-wordpress-theme/" target="_blank"><input type="button" value="Upgrade to Pro, unlock all features" class="button button-primary button-large req_btn"></a>';
}

add_action('admin_notices', 'ello_photographer_services_child_admin_notice');
?>
