<?php
function electrical_repair_get_all_google_fonts() {
    $electrical_repair_webfonts_json = get_template_directory() . '/theme-library/google-webfonts.json';
    if ( ! file_exists( $electrical_repair_webfonts_json ) ) {
        return array();
    }

    $electrical_repair_fonts_json_data = file_get_contents( $electrical_repair_webfonts_json );
    if ( false === $electrical_repair_fonts_json_data ) {
        return array();
    }

    $electrical_repair_all_fonts = json_decode( $electrical_repair_fonts_json_data, true );
    if ( json_last_error() !== JSON_ERROR_NONE ) {
        return array();
    }

    $electrical_repair_google_fonts = array();
    foreach ( $electrical_repair_all_fonts as $electrical_repair_font ) {
        $electrical_repair_google_fonts[ $electrical_repair_font['family'] ] = array(
            'family'   => $electrical_repair_font['family'],
            'variants' => $electrical_repair_font['variants'],
        );
    }
    return $electrical_repair_google_fonts;
}


function electrical_repair_get_all_google_font_families() {
    $electrical_repair_google_fonts  = electrical_repair_get_all_google_fonts();
    $electrical_repair_font_families = array();
    foreach ( $electrical_repair_google_fonts as $electrical_repair_font ) {
        $electrical_repair_font_families[ $electrical_repair_font['family'] ] = $electrical_repair_font['family'];
    }
    return $electrical_repair_font_families;
}

function electrical_repair_get_fonts_url() {
    $electrical_repair_fonts_url = '';
    $electrical_repair_fonts     = array();

    $electrical_repair_all_fonts = electrical_repair_get_all_google_fonts();

    if ( ! empty( get_theme_mod( 'electrical_repair_site_title_font', 'Playfair Display' ) ) ) {
        $electrical_repair_fonts[] = get_theme_mod( 'electrical_repair_site_title_font', 'Playfair Display' );
    }

    if ( ! empty( get_theme_mod( 'electrical_repair_site_description_font', 'Raleway' ) ) ) {
        $electrical_repair_fonts[] = get_theme_mod( 'electrical_repair_site_description_font', 'Raleway' );
    }

    if ( ! empty( get_theme_mod( 'electrical_repair_header_font', 'Epilogue' ) ) ) {
        $electrical_repair_fonts[] = get_theme_mod( 'electrical_repair_header_font', 'Epilogue' );
    }

    if ( ! empty( get_theme_mod( 'electrical_repair_content_font', 'Raleway' ) ) ) {
        $electrical_repair_fonts[] = get_theme_mod( 'electrical_repair_content_font', 'Raleway' );
    }

    $electrical_repair_fonts = array_unique( $electrical_repair_fonts );

    foreach ( $electrical_repair_fonts as $electrical_repair_font ) {
        $electrical_repair_variants      = $electrical_repair_all_fonts[ $electrical_repair_font ]['variants'];
        $electrical_repair_font_family[] = $electrical_repair_font . ':' . implode( ',', $electrical_repair_variants );
    }

    $electrical_repair_query_args = array(
        'family' => urlencode( implode( '|', $electrical_repair_font_family ) ),
    );

    if ( ! empty( $electrical_repair_font_family ) ) {
        $electrical_repair_fonts_url = add_query_arg( $electrical_repair_query_args, 'https://fonts.googleapis.com/css' );
    }

    return $electrical_repair_fonts_url;
}