<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package electrical_repair
 */

//Global Color
function electrical_repair_customize_css() {
	$electrical_repair_primary_color = get_theme_mod( 'primary_color', '#1F87FF' );
	$electrical_repair_custom_css = ":root { --primary-color: {$electrical_repair_primary_color}; }";

	wp_add_inline_style( 'electrical-repair-style', $electrical_repair_custom_css );
}
add_action( 'wp_enqueue_scripts', 'electrical_repair_customize_css' );

//Google Fonts
function electrical_repair_enqueue_selected_fonts() {
    $electrical_repair_fonts_url = electrical_repair_get_fonts_url();
    if (!empty($electrical_repair_fonts_url)) {
        wp_enqueue_style('electrical-repair-google-fonts', $electrical_repair_fonts_url, array(), null);
    }
}
add_action('wp_enqueue_scripts', 'electrical_repair_enqueue_selected_fonts');

//Set Width
function electrical_repair_layout_customizer_css() {
	$electrical_repair_margin = get_theme_mod( 'electrical_repair_layout_width_margin', 50 );
	$electrical_repair_custom_css = "body.site-boxed--layout #page { margin: 0 {$electrical_repair_margin}px; }";

	wp_add_inline_style( 'electrical-repair-style', $electrical_repair_custom_css );
}
add_action( 'wp_enqueue_scripts', 'electrical_repair_layout_customizer_css', 20 );

//Blog Content Alignment
function electrical_repair_blog_layout_customizer_css() {
	// Retrieve the blog layout option
	$electrical_repair_layout_option = get_theme_mod( 'electrical_repair_blog_layout_option_setting', 'Left' );

	// Determine text alignment based on option
	switch ( $electrical_repair_layout_option ) {
		case 'Right':
			$electrical_repair_text_align = 'right';
			break;
		case 'Default':
			$electrical_repair_text_align = 'center';
			break;
		case 'Left':
		default:
			$electrical_repair_text_align = 'left';
			break;
	}

	// Create custom CSS
	$electrical_repair_custom_css = ".mag-post-detail { text-align: {$electrical_repair_text_align}; }";

	// Attach CSS to theme style
	wp_add_inline_style( 'electrical-repair-style', $electrical_repair_custom_css );
}
add_action( 'wp_enqueue_scripts', 'electrical_repair_blog_layout_customizer_css' );

//Sidebar Width Setting
function electrical_repair_sidebar_width_customizer_css() {
	$electrical_repair_sidebar_width = get_theme_mod( 'electrical_repair_sidebar_width', '30' );

	$electrical_repair_custom_css = "
		.right-sidebar .asterthemes-wrapper .asterthemes-page {
			grid-template-columns: auto {$electrical_repair_sidebar_width}%;
		}
		.left-sidebar .asterthemes-wrapper .asterthemes-page {
			grid-template-columns: {$electrical_repair_sidebar_width}% auto;
		}
	";

	wp_add_inline_style( 'electrical-repair-style', $electrical_repair_custom_css );
}
add_action( 'wp_enqueue_scripts', 'electrical_repair_sidebar_width_customizer_css' );

if ( ! function_exists( 'electrical_repair_get_page_title' ) ) {
    function electrical_repair_get_page_title() {
        $electrical_repair_title = '';

        if (is_404()) {
            $electrical_repair_title = esc_html__('Page Not Found', 'electrical-repair');
        } elseif (is_search()) {
            $electrical_repair_title = esc_html__('Search Results for: ', 'electrical-repair') . esc_html(get_search_query());
        } elseif (is_home() && !is_front_page()) {
            $electrical_repair_title = esc_html__('Blogs', 'electrical-repair');
        } elseif (function_exists('is_shop') && is_shop()) {
            $electrical_repair_title = esc_html__('Shop', 'electrical-repair');
        } elseif (is_page()) {
            $electrical_repair_title = get_the_title();
        } elseif (is_single()) {
            $electrical_repair_title = get_the_title();
        } elseif (is_archive()) {
            $electrical_repair_title = get_the_archive_title();
        } else {
            $electrical_repair_title = get_the_archive_title();
        }

        return apply_filters('electrical_repair_page_title', $electrical_repair_title);
    }
}

if ( ! function_exists( 'electrical_repair_has_page_header' ) ) {
    function electrical_repair_has_page_header() {
        // Default to true (display header)
        $electrical_repair_return = true;

        // Custom conditions for disabling the header
        if ('hide-all-devices' === get_theme_mod('electrical_repair_page_header_visibility', 'all-devices')) {
            $electrical_repair_return = false;
        }

        // Apply filters and return
        return apply_filters('electrical_repair_display_page_header', $electrical_repair_return);
    }
}

if ( ! function_exists( 'electrical_repair_page_header_style' ) ) {
    function electrical_repair_page_header_style() {
        $electrical_repair_style = get_theme_mod('electrical_repair_page_header_style', 'default');
        return apply_filters('electrical_repair_page_header_style', $electrical_repair_style);
    }
}

//Page Title Options
function electrical_repair_page_title_customizer_css() {
	$electrical_repair_layout_option = get_theme_mod( 'electrical_repair_page_header_layout', 'left' );
	$electrical_repair_custom_css = '';

	if ( $electrical_repair_layout_option === 'flex' ) {
		$electrical_repair_custom_css .= '
			.asterthemes-wrapper.page-header-inner {
				display: flex;
				justify-content: space-between;
				align-items: center;
			}
		';
	} else {
		$electrical_repair_custom_css .= "
			.asterthemes-wrapper.page-header-inner {
				text-align: {$electrical_repair_layout_option};
			}
		";
	}

	wp_add_inline_style( 'electrical-repair-style', $electrical_repair_custom_css );
}
add_action( 'wp_enqueue_scripts', 'electrical_repair_page_title_customizer_css' );

//Set Height
function electrical_repair_pagetitle_height_css() {
	$electrical_repair_height = get_theme_mod( 'electrical_repair_pagetitle_height', 50 );

	$electrical_repair_custom_css = "
		header.page-header {
			padding: {$electrical_repair_height}px 0;
		}
	";

	wp_add_inline_style( 'electrical-repair-style', $electrical_repair_custom_css );
}
add_action( 'wp_enqueue_scripts', 'electrical_repair_pagetitle_height_css' );

//Adjust Site Logo Width
function electrical_repair_site_logo_width() {
	$electrical_repair_logo_width = get_theme_mod( 'electrical_repair_site_logo_width', 187 );

	$electrical_repair_custom_css = "
		.site-logo img {
			max-width: {$electrical_repair_logo_width}px;
		}
	";

	wp_add_inline_style( 'electrical-repair-style', $electrical_repair_custom_css );
}
add_action( 'wp_enqueue_scripts', 'electrical_repair_site_logo_width' );

//Menu Font Size
function electrical_repair_menu_font_size_css() {
	$electrical_repair_font_size = get_theme_mod( 'electrical_repair_menu_font_size', 14 );

	$electrical_repair_custom_css = "
		.main-navigation a {
			font-size: {$electrical_repair_font_size}px;
		}
	";

	wp_add_inline_style( 'electrical-repair-style', $electrical_repair_custom_css );
}
add_action( 'wp_enqueue_scripts', 'electrical_repair_menu_font_size_css' );

//Menu Font Weight
function electrical_repair_menu_font_weight_css() {
	$electrical_repair_font_weight = get_theme_mod( 'electrical_repair_menu_font_weight', 500 );

	$electrical_repair_custom_css = "
		.main-navigation a {
		    font-weight: {$electrical_repair_font_weight};
		}
	";

	wp_add_inline_style( 'electrical-repair-style', $electrical_repair_custom_css );
}
add_action( 'wp_enqueue_scripts', 'electrical_repair_menu_font_weight_css' );

// Featured Image Dimension
function electrical_repair_custom_featured_image_css() {
    $electrical_repair_dimension = get_theme_mod('electrical_repair_blog_post_featured_image_dimension', 'default');
    $electrical_repair_width = get_theme_mod('electrical_repair_blog_post_featured_image_custom_width', '');
    $electrical_repair_height = get_theme_mod('electrical_repair_blog_post_featured_image_custom_height', '');
    
    if ($electrical_repair_dimension === 'custom' && $electrical_repair_width && $electrical_repair_height) {
        $electrical_repair_custom_css = "body:not(.single-post) .mag-post-single .mag-post-img img { width: {$electrical_repair_width}px !important; height: {$electrical_repair_height}px !important; }";
        wp_add_inline_style('electrical-repair-style', $electrical_repair_custom_css);
    }
}
add_action('wp_enqueue_scripts', 'electrical_repair_custom_featured_image_css');

// Featured Image Border Radius
function electrical_repair_featured_image_border_radius_css() {
	$electrical_repair_radius = get_theme_mod( 'electrical_repair_featured_image_border_radius', 10 );

	$electrical_repair_custom_css = "
		.mag-post-single img {
			border-radius: {$electrical_repair_radius}px;
		}
	";

	wp_add_inline_style( 'electrical-repair-style', $electrical_repair_custom_css );
}
add_action( 'wp_enqueue_scripts', 'electrical_repair_featured_image_border_radius_css' );

// Woocommerce Related Products Settings
function electrical_repair_sidebar_widget_font_size_css() {
	$electrical_repair_sidebar_widget_font_size = get_theme_mod( 'electrical_repair_sidebar_widget_font_size', 24 );

	$electrical_repair_custom_css = "
		h2.wp-block-heading,
		aside#secondary .widgettitle,
		aside#secondary .widget-title {
			font-size: {$electrical_repair_sidebar_widget_font_size}px;
		}
	";

	wp_add_inline_style( 'electrical-repair-style', $electrical_repair_custom_css );
}
add_action( 'wp_enqueue_scripts', 'electrical_repair_sidebar_widget_font_size_css' );

// Product Sale Badge Position
function electrical_repair_product_sale_position_customizer_css() {
    $electrical_repair_position = get_theme_mod('electrical_repair_product_sale_position', 'left');
    $electrical_repair_css = '.woocommerce ul.products li.product .onsale {';
    if ($electrical_repair_position === 'left') {
        $electrical_repair_css .= 'right: auto; left: 0px;';
    } else {
        $electrical_repair_css .= 'left: auto; right: 0px;';
    }
    $electrical_repair_css .= '}';
    wp_add_inline_style('electrical-repair-style', $electrical_repair_css);
}
add_action('wp_enqueue_scripts', 'electrical_repair_product_sale_position_customizer_css');

// Footer Copyright Alignment
function electrical_repair_footer_copyright_alignment_css() {
    $electrical_repair_align = get_theme_mod('electrical_repair_footer_bottom_align', 'center');
    $electrical_repair_css = "
        .site-footer .site-footer-bottom .site-footer-bottom-wrapper {
            justify-content: {$electrical_repair_align};
        }
        @media screen and (max-width: 575px) {
            .site-footer .site-footer-bottom .site-footer-bottom-wrapper {
                justify-content: center;
                text-align: center;
            }
        }
    ";
    wp_add_inline_style('electrical-repair-style', $electrical_repair_css);
}
add_action('wp_enqueue_scripts', 'electrical_repair_footer_copyright_alignment_css');

// Footer Copyright Font Size
function electrical_repair_copyright_font_size_css() {
    $electrical_repair_font_size = get_theme_mod('electrical_repair_copyright_font_size', 16);
    $electrical_repair_css = ".site-footer-bottom .site-info span {
        font-size: {$electrical_repair_font_size}px;
    }";
    wp_add_inline_style('electrical-repair-style', $electrical_repair_css);
}
add_action('wp_enqueue_scripts', 'electrical_repair_copyright_font_size_css');

// Preloader Background Color
function electrical_repair_preloader_background_colors_css() {
    $electrical_repair_color = get_theme_mod('electrical_repair_preloader_background_color_setting', '');
    if (!empty($electrical_repair_color)) {
        $electrical_repair_css = "#loader {
            background-color: {$electrical_repair_color};
        }";
        wp_add_inline_style('electrical-repair-style', $electrical_repair_css);
    }
}
add_action('wp_enqueue_scripts', 'electrical_repair_preloader_background_colors_css');

// Preloader Background Image
function electrical_repair_preloader_background_image_css() {
    $electrical_repair_image_url = get_theme_mod('electrical_repair_preloader_background_image_setting', '');
    if (!empty($electrical_repair_image_url)) {
        $electrical_repair_css = "#loader {
            background-image: url('{$electrical_repair_image_url}');
            background-size: cover;
            background-repeat: no-repeat;
            background-position: center;
        }";
        wp_add_inline_style('electrical-repair-style', $electrical_repair_css);
    }
}
add_action('wp_enqueue_scripts', 'electrical_repair_preloader_background_image_css');

// Footer Heading Alignment
function electrical_repair_footer_heading_alignment_css() {
    $electrical_repair_align = get_theme_mod('electrical_repair_footer_header_align', 'left');
    $electrical_repair_css = "
        .site-footer h4,
        footer#colophon h2.wp-block-heading,
        footer#colophon .widgettitle,
        footer#colophon .widget-title {
            text-align: {$electrical_repair_align};
        }
    ";
    wp_add_inline_style('electrical-repair-style', $electrical_repair_css);
}

// Footer Image Position
