<?php
/**
 * WooCommerce Settings
 *
 * @package electrical_repair
 */

$wp_customize->add_section(
	'electrical_repair_woocommerce_settings',
	array(
		'panel' => 'electrical_repair_theme_options',
		'title' => esc_html__( 'WooCommerce Settings', 'electrical-repair' ),
	)
);

//WooCommerce - Products per page.
$wp_customize->add_setting( 'electrical_repair_products_per_page', array(
    'default'           => 9,
    'sanitize_callback' => 'absint',
));

$wp_customize->add_control( 'electrical_repair_products_per_page', array(
    'type'        => 'number',
    'section'     => 'electrical_repair_woocommerce_settings',
    'label'       => __( 'Products Per Page', 'electrical-repair' ),
    'input_attrs' => array(
        'min'  => 0,
        'max'  => 50,
        'step' => 1,
    ),
));

//WooCommerce - Products per row.
$wp_customize->add_setting( 'electrical_repair_products_per_row', array(
    'default'           => '3',
    'sanitize_callback' => 'electrical_repair_sanitize_choices',
) );

$wp_customize->add_control( 'electrical_repair_products_per_row', array(
    'label'    => __( 'Products Per Row', 'electrical-repair' ),
    'section'  => 'electrical_repair_woocommerce_settings',
    'settings' => 'electrical_repair_products_per_row',
    'type'     => 'select',
    'choices'  => array(
        '2' => '2',
		'3' => '3',
		'4' => '4',
    ),
) );

//WooCommerce - Show / Hide Related Product.
$wp_customize->add_setting(
	'electrical_repair_related_product_show_hide',
	array(
		'default'           => true,
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_related_product_show_hide',
		array(
			'label'   => esc_html__( 'Show / Hide Related product', 'electrical-repair' ),
			'section' => 'electrical_repair_woocommerce_settings',
		)
	)
);

// WooCommerce - Product Sale Position.
$wp_customize->add_setting(
	'electrical_repair_product_sale_position', 
	array(
		'default' => 'left',
		'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control(
	'electrical_repair_product_sale_position', 
	array(
		'label' => __('Product Sale Position', 'electrical-repair'),
		'section' => 'electrical_repair_woocommerce_settings',
		'settings' => 'electrical_repair_product_sale_position',
		'type' => 'radio',
		'choices' => 
	array(
		'left' => __('Left', 'electrical-repair'),
		'right' => __('Right', 'electrical-repair'),
	),
));