<?php
/**
 * Header Options
 *
 * @package electrical_repair
 */
// ---------------------------------------- GENERAL OPTIONBS ----------------------------------------------------

// ---------------------------------------- PRELOADER -----------------------------------------------


$wp_customize->add_section(
	'electrical_repair_general_options',
	array(
		'panel' => 'electrical_repair_theme_options',
		'title' => esc_html__( 'General Options', 'electrical-repair' ),
	)
);

	// Add Separator Custom Control
	$wp_customize->add_setting( 'electrical_repair_preloader_separator', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( new Electrical_Repair_Separator_Custom_Control( $wp_customize, 'electrical_repair_preloader_separator', array(
		'label' => __( 'Enable / Disable Site Preloader Section', 'electrical-repair' ),
		'section' => 'electrical_repair_general_options',
		'settings' => 'electrical_repair_preloader_separator',
	) ) );

// General Options - Enable Preloader.
$wp_customize->add_setting(
	'electrical_repair_enable_preloader',
	array(
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
		'default'           => false,
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_enable_preloader',
		array(
			'label'   => esc_html__( 'Enable Preloader', 'electrical-repair' ),
			'section' => 'electrical_repair_general_options',
		)
	)
);

// Preloader Style Setting
$wp_customize->add_setting(
    'electrical_repair_preloader_style',
    array(
        'default'           => 'style1',
        'sanitize_callback' => 'sanitize_text_field',
    )
);

$wp_customize->add_control(
    'electrical_repair_preloader_style',
    array(
        'type'     => 'select',
        'label'    => esc_html__('Select Preloader Styles', 'electrical-repair'),
		'active_callback' => 'electrical_repair_is_preloader_style',
        'section'  => 'electrical_repair_general_options',
        'choices'  => array(
            'style1' => esc_html__('Style 1', 'electrical-repair'),
            'style2' => esc_html__('Style 2', 'electrical-repair'),
            'style3' => esc_html__('Style 3', 'electrical-repair'),
        ),
    )
);

// Preloader Background Color Setting
$wp_customize->add_setting(
	'electrical_repair_preloader_background_color_setting',
	 array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize, 'electrical_repair_preloader_background_color_setting', 
		array(
			'label' => __('Preloader Background Color', 'electrical-repair'),
			'active_callback' => 'electrical_repair_is_preloader_style',
			'section' => 'electrical_repair_general_options',
		)
	)
);

// Preloader Background Image Setting
$wp_customize->add_setting(
	'electrical_repair_preloader_background_image_setting', 
	array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize, 'electrical_repair_preloader_background_image_setting',
		 array(
			'label' => __('Preloader Background Image', 'electrical-repair'),
			'active_callback' => 'electrical_repair_is_preloader_style',
			'section' => 'electrical_repair_general_options',
		)
	)
);

// ---------------------------------------- BREADCRUMB ----------------------------------------------------


// Add Separator Custom Control
$wp_customize->add_setting( 'electrical_repair_breadcrumb_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Electrical_Repair_Separator_Custom_Control( $wp_customize, 'electrical_repair_breadcrumb_separators', array(
	'label' => __( 'Enable / Disable Breadcrumb Section', 'electrical-repair' ),
	'section' => 'electrical_repair_general_options',
	'settings' => 'electrical_repair_breadcrumb_separators',
)));


// Breadcrumb - Enable Breadcrumb.
$wp_customize->add_setting(
	'electrical_repair_enable_breadcrumb',
	array(
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_enable_breadcrumb',
		array(
			'label'   => esc_html__( 'Enable Breadcrumb', 'electrical-repair' ),
			'section' => 'electrical_repair_general_options',
		)
	)
);

// Breadcrumb - Separator.
$wp_customize->add_setting(
	'electrical_repair_breadcrumb_separator',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '/',
	)
);

$wp_customize->add_control(
	'electrical_repair_breadcrumb_separator',
	array(
		'label'           => esc_html__( 'Separator', 'electrical-repair' ),
		'active_callback' => 'electrical_repair_is_breadcrumb_enabled',
		'section'         => 'electrical_repair_general_options',
	)
);



// ---------------------------------------- PAGINATION ----------------------------------------------------


// Add Separator Custom Control
$wp_customize->add_setting( 'electrical_repair_pagination_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Electrical_Repair_Separator_Custom_Control( $wp_customize, 'electrical_repair_pagination_separator', array(
	'label' => __( 'Enable / Disable Pagination Section', 'electrical-repair' ),
	'section' => 'electrical_repair_general_options',
	'settings' => 'electrical_repair_pagination_separator',
) ) );


// Pagination - Enable Pagination.
$wp_customize->add_setting(
	'electrical_repair_enable_pagination',
	array(
		'default'           => true,
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_enable_pagination',
		array(
			'label'    => esc_html__( 'Enable Pagination', 'electrical-repair' ),
			'section'  => 'electrical_repair_general_options',
			'settings' => 'electrical_repair_enable_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Type.
$wp_customize->add_setting(
	'electrical_repair_pagination_type',
	array(
		'default'           => 'default',
		'sanitize_callback' => 'electrical_repair_sanitize_select',
	)
);

$wp_customize->add_control(
	'electrical_repair_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Type', 'electrical-repair' ),
		'section'         => 'electrical_repair_general_options',
		'settings'        => 'electrical_repair_pagination_type',
		'active_callback' => 'electrical_repair_is_pagination_enabled',
		'type'            => 'select',
		'choices'         => array(
			'default' => __( 'Default (Older/Newer)', 'electrical-repair' ),
			'numeric' => __( 'Numeric', 'electrical-repair' ),
		),
	)
);



// ---------------------------------------- Website layout ----------------------------------------------------


// Add Separator Custom Control
$wp_customize->add_setting( 'electrical_repair_layuout_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Electrical_Repair_Separator_Custom_Control( $wp_customize, 'electrical_repair_layuout_separator', array(
	'label' => __( 'Website Layout Setting', 'electrical-repair' ),
	'section' => 'electrical_repair_general_options',
	'settings' => 'electrical_repair_layuout_separator',
)));


$wp_customize->add_setting(
	'electrical_repair_website_layout',
	array(
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
		'default'           => false,
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_website_layout',
		array(
			'label'   => esc_html__('Boxed Layout', 'electrical-repair'),
			'section' => 'electrical_repair_general_options',
		)
	)
);


$wp_customize->add_setting('electrical_repair_layout_width_margin', array(
	'default'           => 50,
	'sanitize_callback' => 'electrical_repair_sanitize_range_value',
));

$wp_customize->add_control(new Electrical_Repair_Customize_Range_Control($wp_customize, 'electrical_repair_layout_width_margin', array(
		'label'       => __('Set Width', 'electrical-repair'),
		'description' => __('Adjust the width around the website layout by moving the slider. Use this setting to customize the appearance of your site to fit your design preferences.', 'electrical-repair'),
		'section'     => 'electrical_repair_general_options',
		'settings'    => 'electrical_repair_layout_width_margin',
		'active_callback' => 'electrical_repair_is_layout_enabled',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 130,
			'step' => 1,
		),
)));


// ---------------------------------------- HEADER OPTIONS ----------------------------------------------------	


$wp_customize->add_section(
	'electrical_repair_header_options',
	array(
		'panel' => 'electrical_repair_theme_options',
		'title' => esc_html__( 'Header Options', 'electrical-repair' ),
	)
);


// Add setting for sticky header
$wp_customize->add_setting(
	'electrical_repair_enable_sticky_header',
	array(
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
		'default'           => false,
	)
);

// Add control for sticky header setting
$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_enable_sticky_header',
		array(
			'label'   => esc_html__( 'Enable Sticky Header', 'electrical-repair' ),
			'section' => 'electrical_repair_header_options',
		)
	)
);

// Banner Section - Enable Section.
$wp_customize->add_setting(
	'electrical_repair_enable_header_search_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_enable_header_search_section',
		array(
			'label'    => esc_html__( 'Enable Search Section', 'electrical-repair' ),
			'section'  => 'electrical_repair_header_options',
			'settings' => 'electrical_repair_enable_header_search_section',
		)
	)
);

// Contact Section - Opening Timing.
$wp_customize->add_setting(
	'electrical_repair_opening_timing',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'electrical_repair_opening_timing',
	array(
		'label'           => esc_html__( 'Opening Timing', 'electrical-repair' ),
		'section'         => 'electrical_repair_header_options',
		'type'            => 'text',
	)
);

// Topbar Section - Topbar Location icon.
$wp_customize->add_setting(
    'electrical_repair_location_header_icon',
    array(
        'default' => 'fas fa-map-marker-alt', // Set default icon here
        'sanitize_callback' => 'sanitize_text_field',
        'capability' => 'edit_theme_options',
    )
);

$wp_customize->add_control(new Electrical_Repair_Change_Icon_Control(
    $wp_customize, 
    'electrical_repair_location_header_icon',
    array(
        'label'    => __('Topbar Location Icon','electrical-repair'),
        'section'  => 'electrical_repair_header_options',
        'iconset'  => 'fa',
    )
));

// Topbar Section - Topbar Mail Label.
$wp_customize->add_setting(
	'electrical_repair_email_topbar_address',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'electrical_repair_email_topbar_address',
	array(
		'label'           => esc_html__( 'Topbar Location', 'electrical-repair'  ),
		'section'         => 'electrical_repair_header_options',
		'settings'        => 'electrical_repair_email_topbar_address',
		'type'            => 'text',
	)
);

// Contact Section - Phone Icon.
$wp_customize->add_setting(
    'electrical_repair_header_phone_icon',
    array(
        'default' => 'fas fa-phone-alt', // Set default icon here
        'sanitize_callback' => 'sanitize_text_field',
        'capability' => 'edit_theme_options',
    )
);

$wp_customize->add_control(new Electrical_Repair_Change_Icon_Control(
    $wp_customize, 
    'electrical_repair_header_phone_icon',
    array(
        'label'    => __('Phone Icon','electrical-repair'),
        'section'  => 'electrical_repair_header_options',
        'iconset'  => 'fa',
    )
));

// Contact Section - Phone Number.
$wp_customize->add_setting(
	'electrical_repair_phone_number',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'electrical_repair_phone_number',
	array(
		'label'           => esc_html__( 'Phone Number', 'electrical-repair' ),
		'section'         => 'electrical_repair_header_options',
		'settings'        => 'electrical_repair_phone_number',
		'type'            => 'text',
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'electrical_repair_menu_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Electrical_Repair_Separator_Custom_Control( $wp_customize, 'electrical_repair_menu_separator', array(
	'label' => __( 'Menu Settings', 'electrical-repair' ),
	'section' => 'electrical_repair_header_options',
	'settings' => 'electrical_repair_menu_separator',
)));

$wp_customize->add_setting( 'electrical_repair_menu_font_size', array(
    'default'           => 15,
    'sanitize_callback' => 'absint',
) );

// Add control for site title size
$wp_customize->add_control( 'electrical_repair_menu_font_size', array(
    'type'        => 'number',
    'section'     => 'electrical_repair_header_options',
    'label'       => __( 'Menu Font Size ', 'electrical-repair' ),
    'input_attrs' => array(
        'min'  => 10,
        'max'  => 100,
        'step' => 1,
    ),
));

// Add setting for menu font weight
$wp_customize->add_setting('electrical_repair_menu_font_weight', array(
    'default'           => '500',
    'sanitize_callback' => 'sanitize_text_field',
));

// Add control for menu font weight
$wp_customize->add_control('electrical_repair_menu_font_weight', array(
    'type'     => 'select',
    'section'  => 'electrical_repair_header_options', 
    'label'    => __('Menu Font Weight', 'electrical-repair'),
    'choices'  => array(
		'100' => __('100','electrical-repair'),
		'200' => __('200','electrical-repair'),
		'300' => __('300','electrical-repair'),
		'400' => __('400','electrical-repair'),
		'500' => __('500','electrical-repair'),
		'600' => __('600','electrical-repair'),
		'700' => __('700','electrical-repair'),
		'800' => __('800','electrical-repair'),
		'900' => __('900','electrical-repair'),
    ),
));

// Add setting for menu text transform
$wp_customize->add_setting('electrical_repair_menu_text_transform', array(
    'default'           => 'uppercase', // Default value for text transform
    'sanitize_callback' => 'sanitize_text_field',
));

// Add control for menu text transform
$wp_customize->add_control('electrical_repair_menu_text_transform', array(
    'type'     => 'select',
    'section'  => 'electrical_repair_header_options', // Section where the control will appear
    'label'    => __('Menu Text Transform', 'electrical-repair'),
    'choices'  => array(
        'none'       => __('None', 'electrical-repair'),
        'capitalize' => __('Capitalize', 'electrical-repair'),
        'uppercase'  => __('Uppercase', 'electrical-repair'),
        'lowercase'  => __('Lowercase', 'electrical-repair'),
    ),
));

// Menu Text Color 
$wp_customize->add_setting(
	'electrical_repair_menu_text_color', 
	array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize, 
		'electrical_repair_menu_text_color', 
		array(
			'label' => __('Menu Color', 'electrical-repair'),
			'section' => 'electrical_repair_header_options',
		)
	)
);

// Sub Menu Text Color 
$wp_customize->add_setting(
	'electrical_repair_sub_menu_text_color', 
	array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize, 
		'electrical_repair_sub_menu_text_color', 
		array(
			'label' => __('Sub Menu Color', 'electrical-repair'),
			'section' => 'electrical_repair_header_options',
		)
	)
);

// ----------------------------------------SITE IDENTITY----------------------------------------------------

$wp_customize->add_setting( 'electrical_repair_site_title_size', array(
    'default'           => 30, // Default font size in pixels
    'sanitize_callback' => 'absint', // Sanitize the input as a positive integer
) );

// Add control for site title size
$wp_customize->add_control( 'electrical_repair_site_title_size', array(
    'type'        => 'number',
    'section'     => 'title_tagline', // You can change this section to your preferred section
    'label'       => __( 'Site Title Font Size ', 'electrical-repair' ),
    'input_attrs' => array(
        'min'  => 10,
        'max'  => 100,
        'step' => 1,
    ),
) );

// Site Logo - Enable Setting.
$wp_customize->add_setting(
	'electrical_repair_enable_site_logo',
	array(
		'default'           => true, // Default is to display the logo.
		'sanitize_callback' => 'electrical_repair_sanitize_switch', // Sanitize using a custom switch function.
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_enable_site_logo',
		array(
			'label'    => esc_html__( 'Enable Site Logo', 'electrical-repair' ),
			'section'  => 'title_tagline', // Section to add this control.
			'settings' => 'electrical_repair_enable_site_logo',
		)
	)
);

// Site Title - Enable Setting.
$wp_customize->add_setting(
	'electrical_repair_enable_site_title_setting',
	array(
		'default'           => false,
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_enable_site_title_setting',
		array(
			'label'    => esc_html__( 'Enable Site Title', 'electrical-repair' ),
			'section'  => 'title_tagline',
			'settings' => 'electrical_repair_enable_site_title_setting',
		)
	)
);


// Tagline - Enable Setting.
$wp_customize->add_setting(
	'electrical_repair_enable_tagline_setting',
	array(
		'default'           => false,
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_enable_tagline_setting',
		array(
			'label'    => esc_html__( 'Enable Tagline', 'electrical-repair' ),
			'section'  => 'title_tagline',
			'settings' => 'electrical_repair_enable_tagline_setting',
		)
	)
);

$wp_customize->add_setting('electrical_repair_site_logo_width', array(
    'default'           => 187,
    'sanitize_callback' => 'electrical_repair_sanitize_range_value',
));

$wp_customize->add_control(new Electrical_Repair_Customize_Range_Control($wp_customize, 'electrical_repair_site_logo_width', array(
    'label'       => __('Adjust Site Logo Width', 'electrical-repair'),
    'description' => __('This setting controls the Width of Site Logo', 'electrical-repair'),
    'section'     => 'title_tagline',
    'settings'    => 'electrical_repair_site_logo_width',
    'input_attrs' => array(
        'min'  => 0,
        'max'  => 400,
        'step' => 5,
    ),
)));