<?php
/**
 * Single Post Options
 *
 * @package electrical_repair
 */

$wp_customize->add_section(
	'electrical_repair_single_post_options',
	array(
		'title' => esc_html__( 'Single Post Options', 'electrical-repair' ),
		'panel' => 'electrical_repair_theme_options',
	)
);


// Post Options - Show / Hide Date.
$wp_customize->add_setting(
	'electrical_repair_single_post_hide_date',
	array(
		'default'           => true,
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_single_post_hide_date',
		array(
			'label'   => esc_html__( 'Show / Hide Date', 'electrical-repair' ),
			'section' => 'electrical_repair_single_post_options',
		)
	)
);

// Post Options - Show / Hide Author.
$wp_customize->add_setting(
	'electrical_repair_single_post_hide_author',
	array(
		'default'           => true,
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_single_post_hide_author',
		array(
			'label'   => esc_html__( 'Show / Hide Author', 'electrical-repair' ),
			'section' => 'electrical_repair_single_post_options',
		)
	)
);

// Post Options - Show / Hide Comments.
$wp_customize->add_setting(
	'electrical_repair_single_post_hide_comments',
	array(
		'default'           => true,
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_single_post_hide_comments',
		array(
			'label'   => esc_html__( 'Show / Hide Comments', 'electrical-repair' ),
			'section' => 'electrical_repair_single_post_options',
		)
	)
);

// Post Options - Show / Hide Time.
$wp_customize->add_setting(
	'electrical_repair_single_post_hide_time',
	array(
		'default'           => true,
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_single_post_hide_time',
		array(
			'label'   => esc_html__( 'Show / Hide Time', 'electrical-repair' ),
			'section' => 'electrical_repair_single_post_options',
		)
	)
);

// Post Options - Show / Hide Category.
$wp_customize->add_setting(
	'electrical_repair_single_post_hide_category',
	array(
		'default'           => true,
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_single_post_hide_category',
		array(
			'label'   => esc_html__( 'Show / Hide Category', 'electrical-repair' ),
			'section' => 'electrical_repair_single_post_options',
		)
	)
);

// Post Options - Show / Hide Tag.
$wp_customize->add_setting(
	'electrical_repair_post_hide_tags',
	array(
		'default'           => true,
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_post_hide_tags',
		array(
			'label'   => esc_html__( 'Show / Hide Tag', 'electrical-repair' ),
			'section' => 'electrical_repair_single_post_options',
		)
	)
);

// Post Options - Comment Title.
$wp_customize->add_setting(
	'electrical_repair_blog_post_comment_title',
	array(
		'default'=> 'Leave a Reply',
		'sanitize_callback'	=> 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'electrical_repair_blog_post_comment_title',
	array(
		'label'	=> __('Comment Title','electrical-repair'),
		'input_attrs' => array(
			'placeholder' => __( 'Leave a Reply', 'electrical-repair' ),
		),
		'section'=> 'electrical_repair_single_post_options',
		'type'=> 'text'
	)
);