<?php
/**
 * Related Post Options
 *
 * @package electrical_repair
 */

$wp_customize->add_section(
	'electrical_repair_related_post_options',
	array(
		'title' => esc_html__( 'Related Post Options', 'electrical-repair' ),
		'panel' => 'electrical_repair_theme_options',
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'electrical_repair_related_post_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Electrical_Repair_Separator_Custom_Control( $wp_customize, 'electrical_repair_related_post_separator', array(
	'label' => __( 'Enable / Disable Related Post Section', 'electrical-repair' ),
	'section' => 'electrical_repair_related_post_options',
	'settings' => 'electrical_repair_related_post_separator',
) ) );

// Post Options - Show / Hide Related Posts.
$wp_customize->add_setting(
	'electrical_repair_post_hide_related_posts',
	array(
		'default'           => true,
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_post_hide_related_posts',
		array(
			'label'   => esc_html__( 'Show / Hide Related Posts', 'electrical-repair' ),
			'section' => 'electrical_repair_related_post_options',
		)
	)
);

// Register setting for number of related posts
$wp_customize->add_setting(
    'electrical_repair_related_posts_count',
    array(
        'default'           => 3,
        'sanitize_callback' => 'absint', // Ensure it's an integer
    )
);

// Add control for number of related posts
$wp_customize->add_control(
    'electrical_repair_related_posts_count',
    array(
        'type'        => 'number',
        'label'       => esc_html__( 'Number of Related Posts to Display', 'electrical-repair' ),
        'section'     => 'electrical_repair_related_post_options',
        'input_attrs' => array(
            'min'  => 1,
            'max'  => 5, // Adjust maximum based on your preference
            'step' => 1,
        ),
    )
);

// Post Options - Related Post Label.
$wp_customize->add_setting(
	'electrical_repair_post_related_post_label',
	array(
		'default'           => 'Related Post',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'electrical_repair_post_related_post_label',
	array(
		'label'    => esc_html__( 'Related Posts Label', 'electrical-repair' ),
		'section'  => 'electrical_repair_related_post_options',
		'settings' => 'electrical_repair_post_related_post_label',
		'type'     => 'text',
	)
);