<?php
function electrical_repair_sanitize_select( $electrical_repair_input, $electrical_repair_setting ) {
	$electrical_repair_input = sanitize_key( $electrical_repair_input );
	$electrical_repair_choices = $electrical_repair_setting->manager->get_control( $electrical_repair_setting->id )->choices;
	return ( array_key_exists( $electrical_repair_input, $electrical_repair_choices ) ? $electrical_repair_input : $electrical_repair_setting->default );
}

function electrical_repair_sanitize_switch( $electrical_repair_input ) {
	if ( true === $electrical_repair_input ) {
		return true;
	} else {
		return false;
	}
}

function electrical_repair_sanitize_google_fonts( $electrical_repair_input, $electrical_repair_setting ) {
	$electrical_repair_choices = $electrical_repair_setting->manager->get_control( $electrical_repair_setting->id )->choices;
	return ( array_key_exists( $electrical_repair_input, $electrical_repair_choices ) ? $electrical_repair_input : $electrical_repair_setting->default );
}

function electrical_repair_sanitize_choices( $electrical_repair_input, $electrical_repair_setting ) {
    global $wp_customize;
    $control = $wp_customize->get_control( $electrical_repair_setting->id );
    if ( array_key_exists( $electrical_repair_input, $control->choices ) ) {
        return $electrical_repair_input;
    } else {
        return $electrical_repair_setting->default;
    }
}

/**
 * Sanitize HTML input.
 *
 * @param string $electrical_repair_input HTML input to sanitize.
 * @return string Sanitized HTML.
 */
function electrical_repair_sanitize_html( $electrical_repair_input ) {
    return wp_kses_post( $electrical_repair_input );
}

/**
 * Sanitize URL input.
 *
 * @param string $electrical_repair_input URL input to sanitize.
 * @return string Sanitized URL.
 */
function electrical_repair_sanitize_url( $electrical_repair_input ) {
    return esc_url_raw( $electrical_repair_input );
}

// Sanitize Scroll Top Position
function electrical_repair_sanitize_scroll_top_position( $electrical_repair_input ) {
    $valid_positions = array( 'bottom-right', 'bottom-left', 'bottom-center' );
    if ( in_array( $electrical_repair_input, $valid_positions ) ) {
        return $electrical_repair_input;
    } else {
        return 'bottom-right'; // Default to bottom-right if invalid value
    }
}

function electrical_repair_sanitize_range_value( $electrical_repair_number, $electrical_repair_setting ) {

	// Ensure input is an absolute integer.
	$electrical_repair_number = absint( $electrical_repair_number );

	// Get the input attributes associated with the setting.
	$electrical_repair_atts = $electrical_repair_setting->manager->get_control( $electrical_repair_setting->id )->input_attrs;

	// Get minimum number in the range.
	$electrical_repair_min = ( isset( $electrical_repair_atts['min'] ) ? $electrical_repair_atts['min'] : $electrical_repair_number );

	// Get maximum number in the range.
	$electrical_repair_max = ( isset( $electrical_repair_atts['max'] ) ? $electrical_repair_atts['max'] : $electrical_repair_number );

	// Get step.
	$electrical_repair_step = ( isset( $electrical_repair_atts['step'] ) ? $electrical_repair_atts['step'] : 1 );

	// If the number is within the valid range, return it; otherwise, return the default.
	return ( $electrical_repair_min <= $electrical_repair_number && $electrical_repair_number <= $electrical_repair_max && is_int( $electrical_repair_number / $electrical_repair_step ) ? $electrical_repair_number : $electrical_repair_setting->default );
}