<?php
/**
 * Banner Section Settings
 *
 * @package electrical_repair
 */

// Add Banner Section
$wp_customize->add_section(
	'electrical_repair_banner_section',
	array(
		'panel'    => 'electrical_repair_front_page_options',
		'title'    => esc_html__( 'Banner Section', 'electrical-repair' ),
		'priority' => 10,
	)
);

// Enable Banner Section
$wp_customize->add_setting(
	'electrical_repair_enable_banner_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_enable_banner_section',
		array(
			'label'    => esc_html__( 'Enable Banner Section', 'electrical-repair' ),
			'section'  => 'electrical_repair_banner_section',
			'settings' => 'electrical_repair_enable_banner_section',
		)
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'electrical_repair_banner_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Electrical_Repair_Separator_Custom_Control( $wp_customize, 'electrical_repair_banner_separators', array(
	'label' => __( 'Select Banner Category', 'electrical-repair' ),
	'section' => 'electrical_repair_banner_section',
	'settings' => 'electrical_repair_banner_separators',
	'active_callback' => 'electrical_repair_is_banner_slider_section_enabled',
)));

// Banner Category Setting
$wp_customize->add_setting(
	'electrical_repair_banner_slider_category',
	array(
		'default'           => 'slider',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Customize_Category_Dropdown_Control(
		$wp_customize,
		'electrical_repair_banner_slider_category',
		array(
			'label'    => __( 'Select Banner Category', 'electrical-repair' ),
			'section'  => 'electrical_repair_banner_section',
			'settings' => 'electrical_repair_banner_slider_category',
			'active_callback' => 'electrical_repair_is_banner_slider_section_enabled',
		)
	)
);

// Button Label
$wp_customize->add_setting(
	'electrical_repair_banner_button_label',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'electrical_repair_banner_button_label',
	array(
		'label'           => esc_html__( 'Button Label', 'electrical-repair'  ),
		'section'         => 'electrical_repair_banner_section',
		'settings'        => 'electrical_repair_banner_button_label',
		'type'            => 'text',
		'active_callback' => 'electrical_repair_is_banner_slider_section_enabled',
	)
);

// Button Link
$wp_customize->add_setting(
	'electrical_repair_banner_button_link',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'electrical_repair_banner_button_link',
	array(
		'label'           => esc_html__( 'Button Link', 'electrical-repair' ),
		'section'         => 'electrical_repair_banner_section',
		'settings'        => 'electrical_repair_banner_button_link',
		'type'            => 'url',
		'active_callback' => 'electrical_repair_is_banner_slider_section_enabled',
	)
);