<?php
/**
 * Sample implementation of the Custom Header feature
 *
 * @link https://developer.wordpress.org/themes/functionality/custom-headers/
 *
 * @package electrical_repair
 */

function electrical_repair_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'electrical_repair_custom_header_args', array(
		'default-text-color'     => 'fff',
		'header-text' 			 =>	false,
		'width'                  => 1360,
		'height'                 => 110,
		'flex-width'         	=> true,
        'flex-height'        	=> true,
		'wp-head-callback'       => 'electrical_repair_header_style',
	) ) );
}

add_action( 'after_setup_theme', 'electrical_repair_custom_header_setup' );

if ( ! function_exists( 'electrical_repair_header_style' ) ) :

	add_action( 'wp_enqueue_scripts', 'electrical_repair_header_style' );
	function electrical_repair_header_style() {
		if ( get_header_image() ) :
		$electrical_repair_custom_css = "
			.page-header{
				background-image:url('".esc_url(get_header_image())."') !important;
				background-size: 100%;
				background-position: center top;
			}";
			   wp_add_inline_style( 'electrical-repair-style', $electrical_repair_custom_css );
		endif;
	}
endif;