<?php
/**
 * Template part for displaying Video Format
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package electrical_repair
 */

?>
<?php $electrical_repair_readmore = get_theme_mod( 'electrical_repair_readmore_button_text','Read More');?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="mag-post-single">
        <?php
			// Get the post ID
			$electrical_repair_post_id = get_the_ID();

			// Check if there are videos embedded in the post content
			$electrical_repair_post = get_post($electrical_repair_post_id);
			$electrical_repair_content = do_shortcode(apply_filters('the_content', $electrical_repair_post->post_content));
			$electrical_repair_embeds = get_media_embedded_in_content($electrical_repair_content);

			if (!empty($electrical_repair_embeds)) {
			    // Loop through embedded media and display videos
			    foreach ($electrical_repair_embeds as $electrical_repair_embed) {
			        // Check if the embed code contains a video tag or specific video providers like YouTube or Vimeo
			        if (strpos($electrical_repair_embed, 'video') !== false || strpos($electrical_repair_embed, 'youtube') !== false || strpos($electrical_repair_embed, 'vimeo') !== false || strpos($electrical_repair_embed, 'dailymotion') !== false || strpos($electrical_repair_embed, 'vine') !== false || strpos($electrical_repair_embed, 'wordPress.tv') !== false || strpos($electrical_repair_embed, 'hulu') !== false) {
			            ?>
			            <div class="custom-embedded-video">
			                <div class="video-container">
			                    <?php echo $electrical_repair_embed; ?>
			                </div>
			                <div class="video-comments">
			                    <?php
			                    // Add your comments section here
			                    comments_template(); // This will include the default WordPress comments template
			                    ?>
			                </div>
			            </div>
			            <?php
			        }
			    }
			}
	    ?>
		<div class="mag-post-detail">
			<div class="mag-post-category">
				<?php electrical_repair_categories_list(); ?>
			</div>
			<?php
			if ( is_singular() ) :
				the_title( '<h1 class="entry-title mag-post-title">', '</h1>' );
			else :
				if ( get_theme_mod( 'electrical_repair_post_hide_post_heading', true ) ) { 
					the_title( '<h2 class="entry-title mag-post-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
			    }
			endif;
			?>
			<div class="mag-post-meta">
				<?php
				electrical_repair_posted_on();
				electrical_repair_posted_by();
				electrical_repair_posted_comments();
				electrical_repair_posted_time();
				?>
			</div>
			<?php if ( get_theme_mod( 'electrical_repair_post_hide_post_content', true ) ) { ?>
				<div class="mag-post-excerpt">
					<?php the_excerpt(); ?>
				</div>
		    <?php } ?>
			<?php if ( get_theme_mod( 'electrical_repair_post_readmore_button', true ) === true ) : ?>
				<div class="mag-post-read-more">
					<a href="<?php the_permalink(); ?>" class="read-more-button">
						<?php if ( ! empty( $electrical_repair_readmore ) ) { ?> <?php echo esc_html( $electrical_repair_readmore ); ?> <?php } ?>
						<i class="<?php echo esc_attr( get_theme_mod( 'electrical_repair_readmore_btn_icon', 'fas fa-chevron-right' ) ); ?>"></i>
					</a>
				</div>
			<?php endif; ?>
		</div>
	</div>

</article><!-- #post-<?php the_ID(); ?> -->