<?php
if ( ! get_theme_mod( 'electrical_repair_enable_product_section', false ) ) {
	return;
}

$electrical_repair_args = '';

electrical_repair_render_service_section( $electrical_repair_args );

/**
 * Render Product Section.
 */
function electrical_repair_render_service_section( $electrical_repair_args ) { ?>
		<section id="electrical_repair_trending_section" class="asterthemes-frontpage-section trending-section trending-style-1">
		<?php
		if ( is_customize_preview() ) :
			electrical_repair_section_link( 'electrical_repair_service_section' );
		endif;

		$electrical_repair_trending_product_heading = get_theme_mod( 'electrical_repair_trending_product_heading');
        $electrical_repair_trending_product_subheading = get_theme_mod( 'electrical_repair_trending_product_subheading');
		?>
		<div class="asterthemes-wrapper">
			<?php if ( ! empty( $electrical_repair_trending_product_heading ) ) { ?>
				<div class="header-contact-inner">
					<h3><?php echo esc_html( $electrical_repair_trending_product_heading ); ?></h3>
				</div>
			<?php } ?>
            <?php if ( ! empty( $electrical_repair_trending_product_subheading ) ) { ?>
				<div class="header-contact-inner">
					<p><?php echo esc_html( $electrical_repair_trending_product_subheading ); ?></p>
				</div>
			<?php } ?>
			<?php $electrical_repair_catData = get_theme_mod('electrical_repair_trending_product_category','');
      if ( class_exists( 'WooCommerce' ) ) {
        $electrical_repair_args = array(
          'post_type' => 'product',
          'posts_per_page' => absint( get_theme_mod( 'electrical_repair_service_post_count', 4 ) ),
          'product_cat' => $electrical_repair_catData,
          'order' => 'ASC'
        );?>
        <div class="product-box"> 
	        <?php $electrical_repair_loop = new WP_Query( $electrical_repair_args );
	        while ( $electrical_repair_loop->have_posts() ) : $electrical_repair_loop->the_post(); global $product; ?>
	            <div class="tab-product">
                    <figure>
                        <?php if (has_post_thumbnail( $electrical_repair_loop->post->ID )) echo get_the_post_thumbnail($electrical_repair_loop->post->ID, 'shop_catalog'); else echo '<img src="'.esc_url(wc_placeholder_img_src()).'" />'; ?>
                    </figure>
                    <div class="box-content intro-button">
                        <?php if( $product->is_type( 'simple' ) ) { woocommerce_template_loop_add_to_cart(  $electrical_repair_loop->post, $product );} ?>
                    </div>
        			<div class="product-content-box">
        				<h5 class="product-text"><a href="<?php echo esc_url(get_permalink( $electrical_repair_loop->post->ID )); ?>"><?php the_title(); ?></a></h5>
                        <div class="<?php echo esc_attr( apply_filters( 'woocommerce_product_price_class', 'price' ) ); ?>">
                            <?php echo $product->get_price_html(); ?></div>
                        <div class="rating-box">
                            <?php if( $product->is_type( 'simple' ) ){ woocommerce_template_loop_rating( $electrical_repair_loop->post, $product ); } ?>	
                        </div>
        			</div>
	            </div>
	        <?php endwhile; wp_reset_postdata(); ?>
	      </div>
      <?php } ?>
		</div>
	</section>
	<?php
}