<?php
if ( ! get_theme_mod( 'electrical_repair_enable_banner_section', false ) ) {
	return;
}

$electrical_repair_banner_category = get_theme_mod( 'electrical_repair_banner_slider_category', 'slider' );

$electrical_repair_args = array(
	'post_type'           => 'post',
	'category_name'       => sanitize_text_field( $electrical_repair_banner_category ),
	'posts_per_page'      => 3,
	'ignore_sticky_posts' => true,
);

$electrical_repair_query = new WP_Query( $electrical_repair_args );

if ( $electrical_repair_query->have_posts() ) :
	$electrical_repair_button_label = get_theme_mod( 'electrical_repair_banner_button_label' );
	$electrical_repair_button_link  = get_theme_mod( 'electrical_repair_banner_button_link' );
	$electrical_repair_button_link  = ! empty( $electrical_repair_button_link ) ? esc_url( $electrical_repair_button_link ) : '';
	?>

	<section id="electrical_repair_banner_section" class="banner-section banner-style-1">
		<?php if ( is_customize_preview() ) : electrical_repair_section_link( 'electrical_repair_banner_section' ); endif; ?>
		<div class="banner-section-wrapper">
			<div class="asterthemes-banner-wrapper banner-slider electrical-repair-carousel-navigation" data-slick='{"autoplay": false }'>
				<?php
				while ( $electrical_repair_query->have_posts() ) :
					$electrical_repair_query->the_post();
					?>
					<div class="banner-single-outer">
						<div class="banner-single">
							<div class="banner-img">
								<?php
								if ( has_post_thumbnail() ) {
									the_post_thumbnail( 'full' );
								} else {
									echo '<img src="' . esc_url( get_template_directory_uri() . '/resource/img/default.png' ) . '" alt="' . esc_attr( get_the_title() ) . '">';
								}
								?>
							</div>
							<div class="banner-caption">
								<div class="asterthemes-wrapper">
									<div class="banner-catption-wrapper">
										<h2 class="banner-caption-title">
											<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
										</h2>
										<div class="mag-post-excerpt"><?php the_excerpt(); ?></div>
										<?php if ( ! empty( $electrical_repair_button_label ) && ! empty( $electrical_repair_button_link ) ) : ?>
											<div class="banner-slider-btn">
												<a href="<?php echo esc_url( $electrical_repair_button_link ); ?>" class="asterthemes-button">
													<?php echo esc_html( $electrical_repair_button_label ); ?>
												</a>
											</div>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
					<?php
				endwhile;
				wp_reset_postdata();
				?>
			</div>
		</div>
	</section>

<?php endif; ?>
