<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! electrical_repair_has_page_header() ) {
    return;
}

$electrical_repair_classes = array( 'page-header' );
$electrical_repair_style = electrical_repair_page_header_style();

if ( $electrical_repair_style ) {
    $electrical_repair_classes[] = $electrical_repair_style . '-page-header';
}

$electrical_repair_visibility = get_theme_mod( 'electrical_repair_page_header_visibility', 'all-devices' );

if ( 'hide-all-devices' === $electrical_repair_visibility ) {
    // Don't show the header at all
    return;
}

if ( 'hide-tablet' === $electrical_repair_visibility ) {
    $electrical_repair_classes[] = 'hide-on-tablet';
} elseif ( 'hide-mobile' === $electrical_repair_visibility ) {
    $electrical_repair_classes[] = 'hide-on-mobile';
} elseif ( 'hide-tablet-mobile' === $electrical_repair_visibility ) {
    $electrical_repair_classes[] = 'hide-on-tablet-mobile';
}

$electrical_repair_PAGE_TITLE_background_color = get_theme_mod('electrical_repair_page_title_background_color_setting', '');

// Get the toggle switch value
$electrical_repair_background_image_enabled = get_theme_mod('electrical_repair_page_header_style', true);

// Add background image to the header if enabled
$electrical_repair_background_image = get_theme_mod( 'electrical_repair_page_header_background_image', '' );
$electrical_repair_background_height = get_theme_mod( 'electrical_repair_page_header_image_height', '200' );
$electrical_repair_inline_style = '';

if ( $electrical_repair_background_image_enabled && ! empty( $electrical_repair_background_image ) ) {
    $electrical_repair_inline_style .= 'background-image: url(' . esc_url( $electrical_repair_background_image ) . '); ';
    $electrical_repair_inline_style .= 'height: ' . esc_attr( $electrical_repair_background_height ) . 'px; ';
    $electrical_repair_inline_style .= 'background-size: cover; ';
    $electrical_repair_inline_style .= 'background-position: center center; ';

    // Add the unique class if the background image is set
    $electrical_repair_classes[] = 'has-background-image';
}

$electrical_repair_classes = implode( ' ', $electrical_repair_classes );
$electrical_repair_heading = get_theme_mod( 'electrical_repair_page_header_heading_tag', 'h1' );
$electrical_repair_heading = apply_filters( 'electrical_repair_page_header_heading', $electrical_repair_heading );

?>

<?php do_action( 'electrical_repair_before_page_header' ); ?>

<header class="<?php echo esc_attr( $electrical_repair_classes ); ?>" style="<?php echo esc_attr( $electrical_repair_inline_style ); ?> background-color: <?php echo esc_attr($electrical_repair_PAGE_TITLE_background_color); ?>;">

    <?php do_action( 'electrical_repair_before_page_header_inner' ); ?>

    <div class="asterthemes-wrapper page-header-inner">

        <?php if ( electrical_repair_has_page_header() ) : ?>

            <<?php echo esc_attr( $electrical_repair_heading ); ?> class="page-header-title">
                <?php echo wp_kses_post( electrical_repair_get_page_title() ); ?>
            </<?php echo esc_attr( $electrical_repair_heading ); ?>>

        <?php endif; ?>

        <?php if ( function_exists( 'electrical_repair_breadcrumb' ) ) : ?>
            <?php electrical_repair_breadcrumb(); ?>
        <?php endif; ?>

    </div><!-- .page-header-inner -->

    <?php do_action( 'electrical_repair_after_page_header_inner' ); ?>

</header><!-- .page-header -->

<?php do_action( 'electrical_repair_after_page_header' ); ?>