<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package electrical_repair
 */

get_header();

$electrical_repair_column = get_theme_mod( 'electrical_repair_archive_column_layout', 'column-1' );
?>
<main id="primary" class="site-main">
	<?php if ( have_posts() ) : ?>
		<div class="electrical_repair-archive-layout grid-layout <?php echo esc_attr( $electrical_repair_column ); ?>">
			<?php
			/* Start the Loop */
			while ( have_posts() ) : the_post();

			get_template_part( 'template-parts/content', get_post_format() );

			endwhile;
			?>
		</div>
		<?php
		do_action( 'electrical_repair_posts_pagination' );
	else :
		get_template_part( 'template-parts/content', 'none' );
	endif;
	?>
</main>
<?php
if ( electrical_repair_is_sidebar_enabled() ) {
	get_sidebar();
}
get_footer();