<?php
/**
 * Title: Projects - Interior Designer
 * Slug: acai/projects-interior-designer
 * Categories: acai_sections, acai_images
 */
?>
<!-- wp:group {"metadata":{"name":"Latest Projects"},"align":"wide","layout":{"type":"default"}} -->
<div class="wp-block-group alignwide">
	<!-- wp:heading {"textAlign":"center","level":3,"style":{"typography":{"textTransform":"uppercase"}}} -->
	<h3 class="wp-block-heading has-text-align-center" style="text-transform:uppercase"><?php esc_html_e( 'Our Latest Projects', 'acai' ); ?></h3>
	<!-- /wp:heading -->

	<!-- wp:columns {"style":{"spacing":{"margin":{"top":"var:preset|spacing|40"}},"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}},"textColor":"contrast"} -->
	<div class="wp-block-columns has-contrast-color has-text-color has-link-color" style="margin-top:var(--wp--preset--spacing--40)">
		<!-- wp:column {"style":{"spacing":{"padding":{"top":"0","bottom":"0"}}},"backgroundColor":"base-2"} -->
		<div class="wp-block-column has-base-2-background-color has-background" style="padding-top:0;padding-bottom:0">
			<!-- wp:cover {"url":"<?php echo esc_url( get_theme_file_uri('assets/images/city.jpg') ); ?>","alt":"","dimRatio":30,"overlayColor":"contrast","isUserOverlayColor":true,"isDark":false,"style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"dimensions":{"aspectRatio":"16/9"}},"textColor":"base","layout":{"type":"default"}} -->
			<div class="wp-block-cover is-light has-base-color has-text-color has-link-color"><span aria-hidden="true" class="wp-block-cover__background has-contrast-background-color has-background-dim-30 has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="<?php echo esc_url( get_theme_file_uri('assets/images/city.jpg') ); ?>" data-object-fit="cover" />
				<div class="wp-block-cover__inner-container">
					<!-- wp:paragraph {"align":"center","style":{"typography":{"textTransform":"uppercase"}},"acaiAnimationType":"fade-in-up","acaiAnimationOffset":4} -->
					<p class="has-text-align-center" style="text-transform:uppercase"><?php esc_html_e( 'The Manhattan Penthouse', 'acai' ); ?></p>
					<!-- /wp:paragraph -->
				</div>
			</div>
			<!-- /wp:cover -->

			<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"},"acaiAnimationType":"fade-in-down","acaiAnimationOffset":4} -->
			<div class="wp-block-group" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
				<!-- wp:paragraph {"align":"center"} -->
				<p class="has-text-align-center"><strong><?php esc_html_e( 'Modern Elegance with City Views', 'acai' ); ?></strong></p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph {"align":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"300"}}} -->
				<p class="has-text-align-center" style="font-style:normal;font-weight:300"><?php esc_html_e( 'This project showcases contemporary luxury with floor-to-ceiling windows, minimalist design, and high-end finishes.', 'acai' ); ?></p>
				<!-- /wp:paragraph -->

				<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|20"}}},"layout":{"type":"flex","justifyContent":"center"}} -->
				<div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--20)">
					<!-- wp:button {"textColor":"contrast","className":"is-style-outline","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}}} -->
					<div class="wp-block-button is-style-outline"><a class="wp-block-button__link has-contrast-color has-text-color has-link-color wp-element-button" href="#"><?php esc_html_e( 'Take a Look', 'acai' ); ?></a></div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"style":{"spacing":{"padding":{"top":"0","bottom":"0"}}},"backgroundColor":"base-2"} -->
		<div class="wp-block-column has-base-2-background-color has-background" style="padding-top:0;padding-bottom:0">
			<!-- wp:cover {"url":"<?php echo esc_url( get_theme_file_uri('assets/images/city.jpg') ); ?>","alt":"","dimRatio":30,"overlayColor":"contrast","isUserOverlayColor":true,"isDark":false,"style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"dimensions":{"aspectRatio":"16/9"}},"textColor":"base","layout":{"type":"default"}} -->
			<div class="wp-block-cover is-light has-base-color has-text-color has-link-color"><span aria-hidden="true" class="wp-block-cover__background has-contrast-background-color has-background-dim-30 has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="<?php echo esc_url( get_theme_file_uri('assets/images/city.jpg') ); ?>" data-object-fit="cover" />
				<div class="wp-block-cover__inner-container">
					<!-- wp:paragraph {"align":"center","style":{"typography":{"textTransform":"uppercase"}},"acaiAnimationType":"fade-in-up","acaiAnimationOffset":4} -->
					<p class="has-text-align-center" style="text-transform:uppercase"><?php esc_html_e( 'Coastal Villa Retreat', 'acai' ); ?></p>
					<!-- /wp:paragraph -->
				</div>
			</div>
			<!-- /wp:cover -->

			<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"},"acaiAnimationType":"fade-in-down","acaiAnimationOffset":4} -->
			<div class="wp-block-group" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
				<!-- wp:paragraph {"align":"center"} -->
				<p class="has-text-align-center"><strong><?php esc_html_e( 'A Harmony of Nature and Luxury', 'acai' ); ?></strong></p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph {"align":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"300"}}} -->
				<p class="has-text-align-center" style="font-style:normal;font-weight:300"><?php esc_html_e( 'Nestled on a serene coastline, this villa embraces a natural aesthetic with warm woods, organic textures, and panoramic ocean views.', 'acai' ); ?></p>
				<!-- /wp:paragraph -->

				<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|20"}}},"layout":{"type":"flex","justifyContent":"center"}} -->
				<div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--20)">
					<!-- wp:button {"textColor":"contrast","className":"is-style-outline","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}}} -->
					<div class="wp-block-button is-style-outline"><a class="wp-block-button__link has-contrast-color has-text-color has-link-color wp-element-button" href="#"><?php esc_html_e( 'Take a Look', 'acai' ); ?></a></div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"style":{"spacing":{"padding":{"top":"0","bottom":"0"}}},"backgroundColor":"base-2"} -->
		<div class="wp-block-column has-base-2-background-color has-background" style="padding-top:0;padding-bottom:0">
			<!-- wp:cover {"url":"<?php echo esc_url( get_theme_file_uri('assets/images/city.jpg') ); ?>","alt":"","dimRatio":30,"overlayColor":"contrast","isUserOverlayColor":true,"style":{"elements":{"link":{"color":{"text":"var:preset|color|base"}}},"dimensions":{"aspectRatio":"16/9"}},"textColor":"base","layout":{"type":"default"}} -->
			<div class="wp-block-cover has-base-color has-text-color has-link-color"><span aria-hidden="true" class="wp-block-cover__background has-contrast-background-color has-background-dim-30 has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="<?php echo esc_url( get_theme_file_uri('assets/images/city.jpg') ); ?>" data-object-fit="cover" />
				<div class="wp-block-cover__inner-container">
					<!-- wp:paragraph {"align":"center","style":{"typography":{"textTransform":"uppercase"}},"acaiAnimationType":"fade-in-up","acaiAnimationOffset":4} -->
					<p class="has-text-align-center" style="text-transform:uppercase"><?php esc_html_e( 'French Farmhouse Renovation', 'acai' ); ?></p>
					<!-- /wp:paragraph -->
				</div>
			</div>
			<!-- /wp:cover -->

			<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"},"acaiAnimationType":"fade-in-down","acaiAnimationOffset":4} -->
			<div class="wp-block-group" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
				<!-- wp:paragraph {"align":"center"} -->
				<p class="has-text-align-center"><strong><?php esc_html_e( 'Rustic Charm with Modern Sophistication', 'acai' ); ?></strong></p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph {"align":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"300"}}} -->
				<p class="has-text-align-center" style="font-style:normal;font-weight:300"><?php esc_html_e( 'This classic French farmhouse renovation brings together the rustic beauty of the countryside with the comforts of modern living.', 'acai' ); ?></p>
				<!-- /wp:paragraph -->

				<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|20"}}},"layout":{"type":"flex","justifyContent":"center"}} -->
				<div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--20)">
					<!-- wp:button {"textColor":"contrast","className":"is-style-outline","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}}} -->
					<div class="wp-block-button is-style-outline"><a class="wp-block-button__link has-contrast-color has-text-color has-link-color wp-element-button" href="#"><?php esc_html_e( 'Take a Look', 'acai' ); ?></a></div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->
