<?php
/**
 *
 * Adds custom Block Styles to the editor.
 *
 * @link https://developer.wordpress.org/block-editor/reference-guides/block-api/block-styles/
 *
 * @package Acai
 */

/**
 * Array of block styles.
 */
if ( ! function_exists( 'acai_block_styles' ) ) {
	function acai_block_styles() {
		return array(
			'gradient-text-1' => array(
				'label' => __( 'Gradient text 1', 'acai' ),
				'blocks' => 'paragraph,heading,site-title,site-tagline,post-title,query-title'
			),
			'gradient-text-2' => array(
				'label' => __( 'Gradient text 2', 'acai' ),
				'blocks' => 'paragraph,heading,site-title,site-tagline,post-title,query-title'
			),
			'gradient-text-3' => array(
				'label' => __( 'Gradient text 3', 'acai' ),
				'blocks' => 'paragraph,heading,site-title,site-tagline,post-title,query-title'
			),
			'gradient-text-4' => array(
				'label' => __( 'Gradient text 4', 'acai' ),
				'blocks' => 'paragraph,heading,site-title,site-tagline,post-title,query-title'
			),
			'links-plain' => array(
				'label' => __( 'Links - plain', 'acai' ),
				'blocks' => 'paragraph,heading,site-title,post-title,post-author,post-author-name,post-author-biography,post-terms,query-pagination-previous,query-pagination-next,query-pagination-numbers,comment-template,comments-pagination,latest-posts,latest-comments,categories,tag-cloud,calendar,footnotes'
			),
			'links-underline-on-hover' => array(
				'label' => __( 'Links - underline on hover', 'acai' ),
				'blocks' => 'paragraph,heading,site-title,post-title,post-author,post-author-name,post-author-biography,post-terms,query-pagination-previous,query-pagination-next,query-pagination-numbers,comment-template,comments-pagination,latest-posts,latest-comments,categories,tag-cloud,calendar,footnotes'
			),
			'thin-line' => array(
				'label' => __( 'Thin Line', 'acai' ),
				'blocks' => 'separator'
			),
			'thick-line' => array(
				'label' => __( 'Thick Line', 'acai' ),
				'blocks' => 'separator'
			),
			'dotted' => array(
				'label' => __( 'Dotted', 'acai' ),
				'blocks' => 'separator'
			),
			'dotted-medium' => array(
				'label' => __( 'Dotted (medium)', 'acai' ),
				'blocks' => 'separator'
			),
			'dotted-large' => array(
				'label' => __( 'Dotted (large)', 'acai' ),
				'blocks' => 'separator'
			),
			'dashed' => array(
				'label' => __( 'Dashed', 'acai' ),
				'blocks' => 'separator'
			),
			'fading' => array(
				'label' => __( 'Fading', 'acai' ),
				'blocks' => 'separator'
			),
			'inline' => array(
				'label' => __( 'Inline', 'acai' ),
				'blocks' => 'list,categories,page-list'
			),
			'circle' => array(
				'label' => __( 'Circle', 'acai' ),
				'blocks' => 'list,list-item,button,query-pagination-numbers'
			),
			'disc' => array(
				'label' => __( 'Disc', 'acai' ),
				'blocks' => 'list,list-item'
			),
			'line' => array(
				'label' => __( 'Line', 'acai' ),
				'blocks' => 'list,list-item'
			),
			'check' => array(
				'label' => __( 'Check', 'acai' ),
				'blocks' => 'list,list-item'
			),
			'cross' => array(
				'label' => __( 'Cross', 'acai' ),
				'blocks' => 'list,list-item'
			),
			'star' => array(
				'label' => __( 'Star', 'acai' ),
				'blocks' => 'list,list-item'
			),
			'arrow' => array(
				'label' => __( 'Arrow', 'acai' ),
				'blocks' => 'list,list-item'
			),
			'chevron' => array(
				'label' => __( 'Chevron', 'acai' ),
				'blocks' => 'list,list-item'
			),
			'counter' => array(
				'label' => __( 'Counter', 'acai' ),
				'blocks' => 'list'
			),
			'none' => array(
				'label' => __( 'No Style', 'acai' ),
				'blocks' => 'list,list-item'
			),
			'stripes-no-border' => array(
				'label' => __( 'Stripes with no border', 'acai' ),
				'blocks' => 'table'
			),
			'rounded-small' => array(
				'label' => __( 'Rounded - small', 'acai' ),
				'blocks' => 'post-comments-form'
			),
			'rounded-medium' => array(
				'label' => __( 'Rounded - medium', 'acai' ),
				'blocks' => 'post-comments-form'
			),
			'rounded-large' => array(
				'label' => __( 'Rounded - large', 'acai' ),
				'blocks' => 'post-comments-form'
			),
			'circle-align-top' => array(
				'label' => __( 'Circle - top align', 'acai' ),
				'blocks' => 'group'
			),
			'circle-align-middle' => array(
				'label' => __( 'Circle - middle align', 'acai' ),
				'blocks' => 'group'
			),
			'circle-align-bottom' => array(
				'label' => __( 'Circle - bottom align', 'acai' ),
				'blocks' => 'group'
			),
			'circle-current' => array(
				'label' => __( 'Circle on Current', 'acai' ),
				'blocks' => 'query-pagination-numbers'
			),
			'button' => array(
				'label' => __( 'Button', 'acai' ),
				'blocks' => 'query-pagination-previous,query-pagination-next'
			),
			'no-border' => array(
				'label' => __( 'No Border', 'acai' ),
				'blocks' => 'search'
			),
			'hover-shadow-natural' => array(
				'label' => __( 'Shadow hover - Natural', 'acai' ),
				'blocks' => 'group'
			),
			'hover-shadow-deep' => array(
				'label' => __( 'Shadow hover - Deep', 'acai' ),
				'blocks' => 'group'
			),
			'hover-shadow-sharp' => array(
				'label' => __( 'Shadow hover - Sharp', 'acai' ),
				'blocks' => 'group'
			),
			'hover-shadow-outlined' => array(
				'label' => __( 'Shadow hover - Outlined', 'acai' ),
				'blocks' => 'group'
			),
			'hover-shadow-crisp' => array(
				'label' => __( 'Shadow hover - Crisp', 'acai' ),
				'blocks' => 'group'
			),
			'hover-shadow-framed' => array(
				'label' => __( 'Shadow hover - Framed', 'acai' ),
				'blocks' => 'group'
			),
			'hover-shadow-glow' => array(
				'label' => __( 'Shadow hover - Glow', 'acai' ),
				'blocks' => 'group'
			),
			'hover-shadow-remove' => array(
				'label' => __( 'Shadow hover - Remove', 'acai' ),
				'blocks' => 'group'
			),
			'last-child-hover' => array(
				'label' => __( 'Last child Group visible on hover', 'acai' ),
				'blocks' => 'group'
			),
			'last-child-hover-no-editor' => array(
				'label' => __( 'Last child Group visible on hover (not in Editor)', 'acai' ),
				'blocks' => 'group'
			)
		);
	}
}

/**
 * Register the block styles.
 */
if ( ! function_exists( 'acai_register_block_styles' ) ) {
	function acai_register_block_styles() {
		$block_styles = acai_block_styles();
		foreach ( $block_styles as $block_style => $attrs ) {
			if ( isset($attrs['label']) && $attrs['label'] !== '' ) {
				$label = $attrs['label'];
			} else {
				$label = $block_style;
			}
			if ( isset($attrs['handle']) && $attrs['handle'] !== '' ) {
				$handle = $attrs['handle'];
			} else {
				$handle = 'acai-style';
			}
			if ( isset($attrs['style']) && $attrs['style'] !== '' ) {
				$style = $attrs['style'];
			} else {
				$style = '';
			}
			$blocks = explode( ',', $attrs['blocks'] );
			$block_count = 0;
			foreach ( $blocks as $block ) {
				$block_count++;
				if ( strpos( $block, '/' ) !== false ) {
					$block = $block;
				} else {
					$block = 'core/' . $block;
				}
				if ( $block_count > 1 ) {
					$style = '';
				}
				register_block_style(
					$block,
					array(
						'name' => $block_style,
						'label'	=> $label,
						'style_handle' => $handle,
						'inline_style' => $style
					)
				);
			}
		}
	}
}
add_action( 'init', 'acai_register_block_styles' );

/**
 * Enqueue the block styles.
 */
if ( ! function_exists( 'acai_enqueue_block_styles' ) ) {
	function acai_enqueue_block_styles() {
		$files = glob( ACAI_TEMPLATE_DIR . '/assets/block-styles/core/*.min.css' );
		foreach ( $files as $file ) {
			$filename = basename( $file, '.min.css' );
			wp_enqueue_block_style(
				'core/' . $filename,
				array(
					'handle' => 'acai-wp-block-' . $filename,
					'src' => get_theme_file_uri( 'assets/block-styles/core/' . $filename . '.min.css' ),
					'path' => get_theme_file_path( 'assets/block-styles/core/' . $filename . '.min.css' ),
					'ver' => ACAI_VERSION
				)
			);
		}
	}
}
add_action( 'init', 'acai_enqueue_block_styles' );

/**
 * Enqueue the editor script.
 */
if ( ! function_exists( 'acai_editor_scripts' ) ) {
	function acai_editor_scripts() {
		wp_enqueue_script( 'acai-editor', ACAI_TEMPLATE_DIR_URI . '/assets/js/editor.js', array('wp-blocks', 'wp-element', 'wp-components', 'wp-block-editor', 'wp-i18n', 'wp-data'), ACAI_VERSION, true );
	}
}
add_action( 'enqueue_block_editor_assets', 'acai_editor_scripts' );

/**
 * Enqueue the frontend styles and scripts.
 */
if ( ! function_exists( 'acai_frontend_styles' ) ) {
	function acai_frontend_styles() {
		wp_enqueue_script( 'acai-animation-script', ACAI_TEMPLATE_DIR_URI . '/assets/js/animation.js', array(), ACAI_VERSION, true );
		wp_enqueue_style( 'acai-animation', ACAI_TEMPLATE_DIR_URI . '/assets/css/animation.min.css', array(), ACAI_VERSION );
		wp_enqueue_style( 'acai-fixes', ACAI_TEMPLATE_DIR_URI . '/assets/css/fixes.min.css', array(), ACAI_VERSION );
	}
}
add_action( 'wp_enqueue_scripts', 'acai_frontend_styles' );

/**
 * Add animation attributes to block markup.
 */
if ( ! function_exists( 'acai_block_animation' ) ) {
	function acai_block_animation( $block_content, $block ) {
		if ( !isset( $block['attrs']['acaiAnimationType'] ) || $block['attrs']['acaiAnimationType'] === 'none' ) {
			return $block_content;
		}
		$type = $block['attrs']['acaiAnimationType'];
		$duration = isset( $block['attrs']['acaiAnimationDuration'] ) ? floatval( $block['attrs']['acaiAnimationDuration'] ) : 1.4;
		$delay = isset( $block['attrs']['acaiAnimationDelay'] ) ? floatval( $block['attrs']['acaiAnimationDelay'] ) : 0;
		$offset = isset( $block['attrs']['acaiAnimationOffset'] ) ? intval( $block['attrs']['acaiAnimationOffset'] ) : 10;
		$scale = isset( $block['attrs']['acaiAnimationScale'] ) ? floatval( $block['attrs']['acaiAnimationScale'] ) : 0.1;
		return preg_replace_callback( '/<(\w+)([^>]*)>/', function( $m ) use ( $type, $duration, $delay, $offset, $scale ) {
			$attrs = $m[2];
			if ( !strpos( $attrs, 'data-acai-animate') ) {
				$attrs .= ' data-acai-animate="' . esc_attr( $type ) . '"';
				$attrs .= ' data-acai-duration="' . esc_attr( $duration ) . '"';
				$attrs .= ' data-acai-delay="' . esc_attr( $delay ) . '"';
				$attrs .= ' data-acai-offset="' . esc_attr( $offset ) . '"';
				$attrs .= ' data-acai-scale="' . esc_attr( $scale ) . '"';
				$attrs .= ' data-acai-animation-state="initial"';
			}
			return '<' . $m[1] . $attrs . '>';
		}, $block_content, 1 );
	}
}

if ( ! function_exists( 'acai_block_render' ) ) {
	function acai_block_render( $block_content, $block ) {
		$block_content = acai_block_animation( $block_content, $block );
		return $block_content;
	}
}
add_filter( 'render_block', 'acai_block_render', 10, 2 );

/**
 * Non-core block styles.
 */
require ACAI_TEMPLATE_DIR . '/inc/block-styles-non-core.php';
