<?php
/**
 *
 * Extra non-core block pattern functionality in addition to /patterns directory.
 *
 * @package Acai
 */

/**
 * "Filter by attribute" block markup for each WooCommerce product attribute,
 * or a single placeholder block if no product attributes exist.
 */
function acai_wc_attribute_filters_block_markup() {
	if ( function_exists( 'wc_get_attribute_taxonomies' ) ) {
		$attrs = wc_get_attribute_taxonomies();
		if ( $attrs ) {
			foreach ( $attrs as $attr ) {
				?>
				<!-- wp:woocommerce/filter-wrapper {"filterType":"attribute-filter","heading":"Filter by attribute"} -->
				<div class="wp-block-woocommerce-filter-wrapper">
					<!-- wp:heading {"level":4,"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"medium"} -->
					<h4 class="wp-block-heading has-medium-font-size" style="margin-top:0;margin-bottom:0"><?php echo esc_html( $attr->attribute_label ); ?></h4>
					<!-- /wp:heading -->

					<!-- wp:woocommerce/attribute-filter {"attributeId":<?php echo esc_attr( $attr->attribute_id ); ?>,"showCounts":true,"heading":"","lock":{"remove":true}} -->
					<div class="wp-block-woocommerce-attribute-filter is-loading"></div>
					<!-- /wp:woocommerce/attribute-filter -->
				</div>
				<!-- /wp:woocommerce/filter-wrapper -->
				<?php
			}
		} else {
			?>
			<!-- wp:woocommerce/filter-wrapper {"filterType":"attribute-filter","heading":"Filter by attribute"} -->
			<div class="wp-block-woocommerce-filter-wrapper">
				<!-- wp:heading {"level":4,"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"medium"} -->
				<h4 class="wp-block-heading has-medium-font-size" style="margin-top:0;margin-bottom:0">Attribute Name</h4>
				<!-- /wp:heading -->

				<!-- wp:woocommerce/attribute-filter {"showCounts":true,"heading":"","lock":{"remove":true}} -->
				<div class="wp-block-woocommerce-attribute-filter is-loading"></div>
				<!-- /wp:woocommerce/attribute-filter -->
			</div>
			<!-- /wp:woocommerce/filter-wrapper -->
			<?php
		}
	}
}
