<?php $__env->startComponent('backend.layouts.components.main',['title' => 'مدیریت نظرات ها', 'titleBar'=>true , 'button' => '' , 'route' => 'admin.comments.create']); ?>

    <?php $__env->slot('breadcrumb'); ?>
        <li class="breadcrumb-item active">
            <a href="<?php echo e(route('admin.index')); ?>">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">نظرات</li>
    <?php $__env->endSlot(); ?>

    
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست نظرات</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>نام کاربر</th>
                            <th>متن نظر</th>
                            <th>نظر در</th>
                            <th>تاریخ ایجاد</th>
                            <th>وضعیت</th>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-comments')): ?>
                                <th>عملیات</th>
                            <?php endif; ?>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php if($comment->user->whatsUserRole()): ?>
                                        <span class="badge badge-pill badge-primary">مدیر</span>
                                    <?php endif; ?>
                                    <?php echo e($comment->user->name); ?>

                                </td>
                                <td><?php echo e(\Illuminate\Support\Str::limit($comment->body , 25)); ?></td>
                                <td>
                                    <?php echo e($comment->commentable->title); ?>

                                </td>
                                <td><?php echo e(\Hekmatinasser\Verta\Verta::instance($comment->created_at)->formatJalaliDate()); ?></td>
                                <td>
                                    <?php if($comment->status == 0): ?>
                                        <span class="btn btn-xs btn-rounded btn-outline-warning">تایید نشده</span>
                                    <?php else: ?>
                                        <span class="btn btn-xs btn-rounded btn-outline-success">تایید شده</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <form action="<?php echo e(route('admin.comments.destroy', $comment->id)); ?>" method="post"
                                          id="delete-<?php echo e($comment->id); ?>">
                                        <?php echo method_field('delete'); ?>
                                        <?php echo csrf_field(); ?>
                                    </form>
                                    <form action="<?php echo e(route('admin.comment.status', $comment->id)); ?>" method="post"
                                          id="status-<?php echo e($comment->id); ?>">
                                        <?php echo method_field('post'); ?>
                                        <?php echo csrf_field(); ?>
                                    </form>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-comments')): ?>
                                        <a href="<?php echo e(route('admin.comments.edit', $comment->id)); ?>" role="button"
                                           class="btn btn-success light sharp" title="ویرایش">
                                            <i class="fa fa-pencil"
                                               onclick="document.getElementById('edit-<?php echo e($comment->id); ?>').submit()"></i>
                                        </a>
                                        <button onclick="document.getElementById('delete-<?php echo e($comment->id); ?>').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>

                                        <?php if($comment->status == 0): ?>
                                            <a role="button"
                                               class="btn btn-success light sharp" title="تایید کردن">
                                                <i class="fa fa-check"
                                                   onclick="document.getElementById('status-<?php echo e($comment->id); ?>').submit()"></i>
                                            </a>
                                        <?php else: ?>
                                            <a role="button"
                                               class="btn btn-warning light sharp" title="عدم تایید">
                                                <i class="fa fa-close"
                                                   onclick="document.getElementById('status-<?php echo e($comment->id); ?>').submit()"></i>
                                            </a>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>

                            </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
                <?php echo e($comments->links()); ?>

            </div>
        </div>
    </div>
    
<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('/backend/js/search.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/icworldco/core/Modules/Comment/Resources/views/backend/all.blade.php ENDPATH**/ ?>