<?php $__env->startComponent('backend.layouts.components.main',['title' => 'ویرایش سفارش','titleBar' => false]); ?>

    <?php $__env->slot('breadcrumb'); ?>
        <li class="breadcrumb-item active">
            <a href="<?php echo e(route('admin.index')); ?>">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">ویرایش سفارش</li>
    <?php $__env->endSlot(); ?>
    

    <div class="col-md-8">
        <div class="sidebar-admin">
            <div class="card-header">
                <h4 class="card-title">جزئیات سفارش</h4>
            </div>
            <div class="card-body">
                <div class="custom-tab-1">
                    <ul class="nav nav-tabs">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#detail">
                                <i class="la la-dot-circle ml-2"></i>
                                جزئیات سفارش
                            </a>
                        </li>
                    </ul>
                    <form action="<?php echo e(route('admin.orders.update' , $order->id)); ?>" method="post" id="store"
                          enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('patch'); ?>
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="detail">
                                <div class="pt-4">
                                    <h5>لیست سفارش و اقلام</h5>
                                    <table class="table table-hover">
                                        <tbody>
                                        <tr>
                                            <th>SKU</th>
                                            <th>نام محصول</th>
                                            <th>تعداد سفارش</th>
                                            <th>قیمت کل</th>
                                        </tr>

                                        <?php $__currentLoopData = $order->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td>
                                                    <?php if($product->sku): ?>
                                                        <?php echo e($product->sku); ?>

                                                    <?php else: ?>
                                                        ندارد
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <strong class="text-black">
                                                        <a class="text-black"
                                                           href="<?php echo e(asset('product/' . $product->slug)); ?>"><?php echo e($product->title); ?></a>
                                                    </strong>
                                                </td>
                                                <td>
                                                    <strong class="text-black">
                                                        <?php echo e($product->pivot->quantity); ?>

                                                    </strong>
                                                </td>
                                                <td>
                                                    <strong class="text-black">
                                                        <?php echo e(number_format($product->pivot->price)); ?>

                                                        تومان
                                                    </strong>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                        </tbody>
                                    </table>


                                    <h5>ارسال به: </h5>
                                    <ul>
                                        <li>
                                            نام سفارش دهنده:
                                            <strong>
                                                <?php echo e($order->address->user->name); ?>

                                            </strong>
                                            <hr>
                                        </li>
                                        <li>
                                            نام خانوادگی:
                                            <strong>
                                                <?php echo e($order->address->user->last_name); ?>

                                            </strong>
                                            <hr>
                                        </li>
                                        <li>
                                            شهر:
                                            <strong>
                                                <?php echo e($order->address->city->name); ?>

                                            </strong>
                                            <hr>
                                        </li>
                                        <li>
                                            کد پستی:
                                            <strong>
                                                <?php echo e($order->address->postal_code); ?>

                                            </strong>
                                            <hr>
                                        </li>
                                        <li>
                                            آدرس:
                                            <strong>
                                                <?php echo e($order->address->address); ?>

                                            </strong>
                                            <hr>
                                        </li>
                                        <li>
                                            روش ارسال:
                                            <strong>
                                                <?php echo e($order->shipping->label); ?>

                                            </strong>
                                        </li>
                                    </ul>

                                </div>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
    

    

    <div class="col-md-4">
        <?php if($errors->any()): ?>
            <div class="alert alert-danger left-icon-big alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span><i
                            class="mdi mdi-close"></i></span>
                </button>
                <div class="media">
                    <div class="alert-left-icon-big">
                        <span><i class="mdi mdi-alert"></i></span>
                    </div>
                    <div class="media-body">
                        <h5 class="mt-1 mb-2">خطا!</h5>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class="mb-0"><?php echo e($error); ?></p>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="<?php echo e(route('admin.orders.index')); ?>" role="button" class="btn btn-xs btn-info light"
                   title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="inputPassword3" class="control-label">وضعیت سفارش</label>
                    <select form="store" name="status" class="form-control">
                        <option value="unpaid" <?php echo e(old('status' , $order->status) == 'unpaid' ? 'selected' : ''); ?>>پرداخت
                            نشده
                        </option>
                        <option value="paid" <?php echo e(old('status' , $order->status) == 'paid' ? 'selected' : ''); ?>>پرداخت
                            شده
                        </option>
                        <option
                            value="preparation" <?php echo e(old('status' , $order->status) == 'preparation' ? 'selected' : ''); ?>>
                            در حال پردازش
                        </option>
                        <option value="posted" <?php echo e(old('status' , $order->status) == 'posted' ? 'selected' : ''); ?>>ارسال
                            شد
                        </option>
                        <option value="received" <?php echo e(old('status' , $order->status) == 'received' ? 'selected' : ''); ?>>
                            دریافت شد
                        </option>
                        <option value="canceled" <?php echo e(old('status' , $order->status) == 'canceled' ? 'selected' : ''); ?>>
                            کنسل شده
                        </option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="inputPassword3" class="control-label">کد پیگیری پستی</label>
                    <input form="store" type="text" name="tracking_serial" class="form-control" id="inputPassword3"
                           placeholder="کد پیگیری را وارد کنید"
                           value="<?php echo e(old('tracking_serial', $order->tracking_serial )); ?>">
                </div>
                <h5>یادداشت سفارش</h5>
                <?php if($order->notes): ?>
                    <p><?php echo e($order->note); ?></p>
                <?php else: ?>
                    <p>بدون یادداشت</p>
                <?php endif; ?>
                <div class="row">
                    <div class="col-md-6">
                        <button class="btn btn-success btn-sm btn-block light"
                                onclick="document.getElementById('store').submit()">
                            <i class="fa fa-refresh"></i>
                            به روز رسانی
                        </button>
                    </div>

                </div>

            </div>
        </div>
    </div>

    

    
<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('/vendor/file-manager/js/file-manager.js')); ?>"></script>
    <script src="<?php echo e(asset('/backend/js/file-editor.js')); ?>"></script>
    <script src="<?php echo e(asset('/backend/js/file-editor2.js')); ?>"></script>
    <script src="<?php echo e(asset('/backend/js/file-button.js')); ?>"></script>
    <script>
        let meta_title = document.getElementById('meta-title');
        let meta_desc = document.getElementById('meta-desc');
        let g_link = document.getElementById('g-link');
        let g_desc = document.getElementById('g-desc');
        meta_title.addEventListener('change', function () {
            g_link.innerText = meta_title.value;
        })
        meta_desc.addEventListener('change', function () {
            g_desc.innerText = meta_desc.value;
        })
    </script>
    <script src="/backend/js/uploader.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('head'); ?>
    <script src="https://cdn.tiny.cloud/1/piqrm2bib3zv8de8a26kklh89gvqb0bhm9a14mjb88jwos8r/tinymce/5/tinymce.min.js"
            referrerpolicy="origin"></script>

    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css">
    <link rel="stylesheet" href="<?php echo e(asset('/vendor/file-manager/css/file-manager.css')); ?>">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet"/>
    <style>
        .upload__box {
            padding: 40px;
        }

        .upload__inputfile {
            width: 0.1px;
            height: 0.1px;
            opacity: 0;
            overflow: hidden;
            position: absolute;
            z-index: -1;
        }

        .upload__btn {
            display: inline-block;
            font-weight: 600;
            color: #fff;
            text-align: center;
            min-width: 116px;
            padding: 5px;
            transition: all 0.3s ease;
            cursor: pointer;
            border: 2px solid;
            background-color: #4045ba;
            border-color: #4045ba;
            border-radius: 10px;
            line-height: 26px;
            font-size: 14px;
        }

        .upload__btn:hover {
            background-color: unset;
            color: #4045ba;
            transition: all 0.3s ease;
        }

        .upload__btn-box {
            margin-bottom: 10px;
        }

        .upload__img-wrap {
            display: flex;
            flex-wrap: wrap;
            margin: 0 -10px;
        }

        .upload__img-box {
            width: 200px;
            padding: 0 10px;
            margin-bottom: 12px;
        }

        .upload__img-close {
            width: 24px;
            height: 24px;
            border-radius: 50%;
            background-color: rgba(0, 0, 0, 0.5);
            position: absolute;
            top: 10px;
            right: 10px;
            text-align: center;
            line-height: 24px;
            z-index: 1;
            cursor: pointer;
        }

        .upload__img-close:after {
            content: "✖";
            font-size: 14px;
            color: white;
        }

        .img-bg {
            background-repeat: no-repeat;
            background-position: center;
            background-size: cover !important;
            position: relative;
            padding-bottom: 100%;
            border-radius: 0.4rem;
        }
    </style>

<?php $__env->stopSection(); ?>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/icworldc/core/Modules/Order/Resources/views/backend/edit.blade.php ENDPATH**/ ?>