<?php $__env->startSection('content'); ?>


    <div class="container mt-5 mb-5">
        <div class="row justify-content-center">
            <div class="col-xl-6 col-lg-8 col-md-9 position-relative" >
                <div class="single-product" id="login-form">
                    <div class="d-flex flex-column align-items-center justify-content-center register">
                        <div class="svg-box">
                            <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 48 48"
                                 fill="none">
                                <rect x="12.3175" y="4.07059" width="23.4898" height="39.1497" rx="5.87245"
                                      stroke="#12131A" stroke-width="2.93622"/>
                                <path opacity="0.3" d="M27.978 5.04988L20.148 5.04988" stroke="#12131A"
                                      stroke-width="4.89371" stroke-linecap="round"/>
                            </svg>
                        </div>
                        <div class="details" id="details">
                            <p class="hide-in-mobile">جهت ورود یا ثبت نام در وب سایت کافیست شماره موبایل خود را وارد
                                کنید</p>
                            <p class="hide-in-mobile">اگر قبلا ثبت نام نکرده اید با وارد کردن شماره موبایل ثبت نام
                                میشوید.</p>
                        </div>
                    </div>
                    <div id="details">
                        <p class="show-in-mobile">اگر قبلا ثبت نام نکرده اید با وارد کردن شماره موبایل ثبت نام
                            میشوید.</p>
                    </div>

                        <div class="input-group mb-3 mt-3" id="phone-input">
                            <span class="input-group-text input-append">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 48 48"
                                     fill="none">
                                <rect x="12.3175" y="4.07059" width="23.4898" height="39.1497" rx="5.87245"
                                      stroke="#12131A" stroke-width="2.93622"/>
                                <path opacity="0.3" d="M27.978 5.04988L20.148 5.04988" stroke="#12131A"
                                      stroke-width="4.89371" stroke-linecap="round"/>
                            </svg>
                                موبایل
                            </span>
                            <input type="text" class="form-control login-input" id="phone" placeholder="مثلا: 09123456789"
                                   aria-label="phone" aria-describedby="phone" name="phone">

                        </div>
                        <p class="text-danger login-error" id="login-error" style="display: none"></p>
                        <div class="token-box" style="display: none">
                            <p class="text-center fw-bold p-3">لطفا کد 4 رقمی ارسال شده به موبایل را وارد کنید</p>
                            <div class="tokens" id="vcode">
                                <input type="number" min="0" max="9" class="vcode-input" maxlength="1" id="vcode1">
                                <input type="number" min="0" max="9" class="vcode-input" maxlength="1" id="vcode2">
                                <input type="number" min="0" max="9" class="vcode-input" maxlength="1" id="vcode3">
                                <input type="number" min="0" max="9" class="vcode-input" maxlength="1" id="vcode4">
                            </div>
                        </div>
                    <a onclick="submitForm()" class="btn btn-default btn-lg  mt-4 w-100 br-1" id="login-btn">ورود / ثبت نام</a>
                </div>
                <span class="add-to-cart-loader cart-loader" style="display: none">
                        <svg xmlns="http://www.w3.org/2000/svg" style="margin: auto;"
                             width="80px" height="80px" viewBox="0 0 100 100"
                             preserveAspectRatio="xMidYMid">
                        <circle cx="50" cy="50" r="32" stroke-width="8" stroke="#ffa701"
                                stroke-dasharray="50.26548245743669 50.26548245743669"
                                fill="none" stroke-linecap="round">
                            <animateTransform attributeName="transform" type="rotate"
                                              repeatCount="indefinite" dur="1s" keyTimes="0;1"
                                              values="0 50 50;360 50 50"/>
                        </circle>
                    </svg>
                    </span>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        function submitForm() {
            event.preventDefault();
            let phone = $('#phone')

            $.ajaxSetup({
                headers : {
                    'X-CSRF-TOKEN' : "<?php echo e(csrf_token()); ?>",
                    'Content-Type' : 'application/json'
                }
            });

            $.ajax({
                type: 'post',
                url : '/login',
                data : JSON.stringify({
                    _method: 'post',
                    phone: phone.val()
                }),
                beforeSend : function () {
                    $('.cart-loader').show();
                    $('#login-form').addClass('blur-2');
                },
                complete : function (response) {
                    $('.cart-loader').hide();
                    $('#login-form').removeClass('blur-2');
                    if (response.responseJSON.success == true) {
                        $('#login-error').css('display' , 'none');
                        $('#phone-input').hide();
                        $('#details').hide();
                        $('.token-box').show();
                        $('#login-btn').text('ورود');
                        $('#login-btn').attr('onclick' , 'submitToken()');
                    }
                    if(response.responseJSON.errors) {
                        $('#login-error').css('display' , 'block');
                        $('#login-error').text(response.responseJSON.message);
                    }
                }
            });
        }

        function submitToken() {
            event.preventDefault();
            let input1 = $('#vcode1').val();
            let input2 = $('#vcode2').val();
            let input3 = $('#vcode3').val();
            let input4 = $('#vcode4').val();

            let token = input1.concat(input2,input3,input4);

            $.ajaxSetup({
                headers : {
                    'X-CSRF-TOKEN' : "<?php echo e(csrf_token()); ?>",
                    'Content-Type' : 'application/json'
                }
            });

            $.ajax({
                type: 'post',
                url : '/token',
                data : JSON.stringify({
                    _method: 'post',
                    token: token
                }),
                beforeSend : function () {
                    $('.cart-loader').show();
                    $('#login-form').addClass('blur-2');
                },
                complete : function (response) {
                    $('.cart-loader').hide();
                    $('#login-form').removeClass('blur-2');
                    if (response.responseJSON.success == true) {
                        window.location.replace('/')
                    }
                    if(response.responseJSON.success == false) {
                        $('#login-error').css('display' , 'block');
                        $('#login-error').text(response.responseJSON.data);
                    }
                    if(response.responseJSON.errors) {
                        $('#login-error').css('display' , 'block');
                        $('#login-error').text(response.responseJSON.message);
                    }
                }
            });
        }

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/icworld/core/Modules/LoginWithCode/Resources/views/auth/login.blade.php ENDPATH**/ ?>