<section class="mb-5 single-product">
    <div class="row">
        <!--product photos-->
        <div class="col-md-12 col-xl-4">

            
            <div style="--swiper-navigation-color: #fff; --swiper-pagination-color: #fff" class="swiper mySwiper2">
                <div class="swiper-wrapper position-relative">
                    <?php if($product->has_thumbnail()): ?>
                        <div class="swiper-slide">
                            <img src="<?php echo e(asset($product->single_image)); ?>"/>
                        </div>
                    <?php else: ?>
                        <div class="swiper-slide">
                            <img src="<?php echo e(asset('/images/other/no-image.jpg')); ?>" alt=""
                                 class="br-1 product-main-image">
                        </div>
                    <?php endif; ?>

                    <?php $__currentLoopData = $product->photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="swiper-slide">
                            <img src="<?php echo e(asset($photo->path)); ?>"/>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php if($product->is_on_sale()): ?>
                        <?php
                            $percentage = round(100 - ($product->sale_price / $product->price * 100));
                        ?>

                        <div class="product-image-labels">
                            <span class="product-label-discount br-1">
                              <i class="fi fi-rr-ticket"></i>
                            <?php echo e($percentage); ?> %
                            </span>
                            <span class="on-sale-label">
                                <svg xmlns="http://www.w3.org/2000/svg" width="38" height="41" viewBox="0 0 38 41">
                                <path
                                    d="M13.12 8.656C13.12 8.82667 13.2053 8.912 13.376 8.912C13.4507 8.912 13.5147 8.89067 13.568 8.848C13.6213 8.79467 13.648 8.73067 13.648 8.656V6.272H16.448V8.912C16.448 9.44533 16.3627 9.904 16.192 10.288C16.0213 10.672 15.792 10.992 15.504 11.248C15.216 11.504 14.8853 11.696 14.512 11.824C14.1493 11.9413 13.7707 12 13.376 12C13.1627 12 12.9013 11.968 12.592 11.904C12.2827 11.84 12.016 11.696 11.792 11.472C11.5253 11.696 11.2693 11.84 11.024 11.904C10.7893 11.968 10.6027 12 10.464 12C10.2507 12 10.0373 11.9787 9.824 11.936C9.62133 11.8933 9.456 11.8293 9.328 11.744L9.76 11.024C9.76 11.6427 9.664 12.224 9.472 12.768C9.28 13.312 8.99733 13.7867 8.624 14.192C8.26133 14.608 7.81333 14.9333 7.28 15.168C6.74667 15.4027 6.13867 15.52 5.456 15.52H4.656C3.99467 15.52 3.40267 15.4187 2.88 15.216C2.368 15.0133 1.93067 14.72 1.568 14.336C1.20533 13.9627 0.928 13.504 0.736 12.96C0.544 12.416 0.448 11.8027 0.448 11.12V7.776H3.344V11.2C3.344 11.6053 3.46133 11.9147 3.696 12.128C3.93067 12.3413 4.30933 12.448 4.832 12.448H5.36C5.936 12.448 6.34667 12.3307 6.592 12.096C6.83733 11.8613 6.96 11.5627 6.96 11.2V6.272H9.76V8.656C9.76 8.73067 9.78667 8.79467 9.84 8.848C9.89333 8.89067 9.95733 8.912 10.032 8.912C10.2027 8.912 10.288 8.82667 10.288 8.656V6.272H13.12V8.656ZM12.752 2.752H10.464V0.559999H12.752V2.752ZM13.904 5.392H9.328V3.2H13.904V5.392ZM24.0266 11.648C24.0266 12.352 23.9253 12.9707 23.7226 13.504C23.5306 14.048 23.2533 14.5013 22.8906 14.864C22.528 15.2267 22.096 15.4987 21.5946 15.68C21.104 15.872 20.5653 15.968 19.9786 15.968H17.5946L17.4186 12.88H20.1546C20.5066 12.88 20.752 12.8107 20.8906 12.672C21.04 12.5333 21.1146 12.3093 21.1146 12H20.8586C20.1973 12 19.6533 11.9253 19.2266 11.776C18.8 11.6267 18.464 11.4187 18.2186 11.152C17.984 10.8747 17.8186 10.5387 17.7226 10.144C17.6373 9.74933 17.5946 9.312 17.5946 8.832C17.5946 8.37333 17.664 7.936 17.8026 7.52C17.9413 7.104 18.144 6.74133 18.4106 6.432C18.688 6.112 19.024 5.86133 19.4186 5.68C19.8133 5.488 20.2613 5.392 20.7626 5.392C21.2 5.392 21.616 5.456 22.0106 5.584C22.4053 5.712 22.752 5.92 23.0506 6.208C23.3493 6.48533 23.584 6.848 23.7546 7.296C23.936 7.73333 24.0266 8.272 24.0266 8.912V11.648ZM20.3306 8.64C20.3306 8.81067 20.3626 8.944 20.4266 9.04C20.4906 9.136 20.6346 9.184 20.8586 9.184H21.2906V8.736C21.2906 8.33067 21.1253 8.128 20.7946 8.128C20.4853 8.128 20.3306 8.29867 20.3306 8.64ZM24.37 12.624C24.946 12.624 25.3513 12.5067 25.586 12.272C25.8313 12.0373 25.954 11.744 25.954 11.392V6.272H28.866V8.688C28.866 8.83733 28.9513 8.912 29.122 8.912H29.73C29.794 8.912 29.8473 8.928 29.89 8.96C29.9433 8.98133 29.9807 9.04 30.002 9.136C30.034 9.232 30.0553 9.38133 30.066 9.584C30.0767 9.78667 30.082 10.064 30.082 10.416C30.082 10.7893 30.0767 11.0827 30.066 11.296C30.0553 11.5093 30.034 11.6693 30.002 11.776C29.9807 11.8827 29.9433 11.9467 29.89 11.968C29.8473 11.9893 29.794 12 29.73 12H29.474C29.218 12 28.994 11.984 28.802 11.952C28.738 12.4747 28.594 12.96 28.37 13.408C28.146 13.8667 27.858 14.2613 27.506 14.592C27.154 14.9333 26.738 15.2 26.258 15.392C25.7887 15.5947 25.2713 15.696 24.706 15.696H23.922L23.666 12.624H24.37ZM30.7904 8.912C30.7264 8.73067 30.6784 8.55467 30.6464 8.384C30.625 8.21333 30.6144 8.04267 30.6144 7.872C30.6144 7.52 30.6784 7.16267 30.8064 6.8C30.945 6.42667 31.1477 6.096 31.4144 5.808C31.681 5.50933 32.017 5.264 32.4224 5.072C32.8384 4.88 33.3184 4.784 33.8624 4.784C34.321 4.784 34.7477 4.848 35.1424 4.976C35.537 5.104 35.873 5.30667 36.1504 5.584C36.4277 5.86133 36.6464 6.224 36.8064 6.672C36.9664 7.12 37.0464 7.664 37.0464 8.304V8.912C37.0464 9.36 36.9717 9.77067 36.8224 10.144C36.6837 10.5173 36.465 10.8427 36.1664 11.12C35.8677 11.3973 35.489 11.616 35.0304 11.776C34.5824 11.9253 34.049 12 33.4304 12H29.7344C29.6704 12 29.617 11.9893 29.5744 11.968C29.521 11.9467 29.4837 11.888 29.4624 11.792C29.4304 11.6853 29.409 11.5307 29.3984 11.328C29.3877 11.1253 29.3824 10.848 29.3824 10.496C29.3824 10.1227 29.3877 9.82933 29.3984 9.616C29.409 9.40267 29.4304 9.248 29.4624 9.152C29.4837 9.04533 29.521 8.98133 29.5744 8.96C29.617 8.928 29.6704 8.912 29.7344 8.912H30.7904ZM34.2144 9.008C34.2677 8.92267 34.2944 8.816 34.2944 8.688C34.305 8.56 34.3104 8.432 34.3104 8.304C34.3104 8.12267 34.273 7.96267 34.1984 7.824C34.1344 7.67467 33.9957 7.6 33.7824 7.6C33.6544 7.6 33.5477 7.64267 33.4624 7.728C33.3877 7.80267 33.3504 7.904 33.3504 8.032C33.3504 8.16 33.393 8.30933 33.4784 8.48C33.5744 8.65067 33.8197 8.82667 34.2144 9.008ZM35.2864 3.904H32.3744V1.712H35.2864V3.904ZM0.448 33.912C0.448 33.3893 0.554667 32.8987 0.768 32.44C0.981333 31.9707 1.312 31.464 1.76 30.92L1.088 30.216L3.136 28.2C3.95733 28.9467 4.61867 29.5973 5.12 30.152C5.62133 30.696 6.00533 31.1867 6.272 31.624C6.54933 32.0507 6.73067 32.4453 6.816 32.808C6.912 33.1707 6.96 33.5387 6.96 33.912C6.96 34.36 6.87467 34.7707 6.704 35.144C6.53333 35.5173 6.29867 35.8427 6 36.12C5.712 36.3973 5.36 36.616 4.944 36.776C4.53867 36.9253 4.096 37 3.616 37C3.136 37 2.69867 36.9253 2.304 36.776C1.90933 36.6267 1.57333 36.4187 1.296 36.152C1.02933 35.8853 0.821333 35.5653 0.672 35.192C0.522667 34.808 0.448 34.3813 0.448 33.912ZM4.224 33.624C4.224 33.3253 4.048 33.016 3.696 32.696C3.344 33.0373 3.168 33.3467 3.168 33.624C3.168 33.9333 3.344 34.088 3.696 34.088C4.048 34.088 4.224 33.9333 4.224 33.624ZM11.0066 33.688C11.0066 33.8373 11.092 33.912 11.2626 33.912H11.8706C11.9346 33.912 11.988 33.928 12.0306 33.96C12.084 33.9813 12.1213 34.04 12.1426 34.136C12.1746 34.232 12.196 34.3813 12.2066 34.584C12.2173 34.7867 12.2226 35.064 12.2226 35.416C12.2226 35.7893 12.2173 36.0827 12.2066 36.296C12.196 36.5093 12.1746 36.6693 12.1426 36.776C12.1213 36.8827 12.084 36.9467 12.0306 36.968C11.988 36.9893 11.9346 37 11.8706 37H11.6146C11.3586 37 11.1346 36.984 10.9426 36.952C10.8786 37.4747 10.7346 37.96 10.5106 38.408C10.2866 38.8667 9.99863 39.2613 9.64663 39.592C9.29463 39.9333 8.87863 40.2 8.39863 40.392C7.92929 40.5947 7.41729 40.696 6.86263 40.696H5.10262L4.83062 37.624H6.51062C7.08662 37.624 7.49196 37.5067 7.72663 37.272C7.97196 37.0373 8.09463 36.744 8.09463 36.392V31.272H11.0066V33.688ZM10.6386 27.752H8.35063V25.56H10.6386V27.752ZM11.7906 30.392H7.21462V28.2H11.7906V30.392ZM14.515 33.912C14.579 33.912 14.6323 33.928 14.675 33.96C14.7283 33.9813 14.7657 34.04 14.787 34.136C14.819 34.232 14.8403 34.3813 14.851 34.584C14.8617 34.7867 14.867 35.064 14.867 35.416C14.867 35.7893 14.8617 36.0827 14.851 36.296C14.8403 36.5093 14.819 36.6693 14.787 36.776C14.7657 36.8827 14.7283 36.9467 14.675 36.968C14.6323 36.9893 14.579 37 14.515 37H11.875C11.811 37 11.7577 36.9893 11.715 36.968C11.6617 36.9467 11.6243 36.888 11.603 36.792C11.571 36.6853 11.5497 36.5307 11.539 36.328C11.5283 36.1253 11.523 35.848 11.523 35.496C11.523 35.1227 11.5283 34.8293 11.539 34.616C11.5497 34.4027 11.571 34.248 11.603 34.152C11.6243 34.0453 11.6617 33.9813 11.715 33.96C11.7577 33.928 11.811 33.912 11.875 33.912H14.515ZM17.1556 33.912C17.2196 33.912 17.273 33.928 17.3156 33.96C17.369 33.9813 17.4063 34.04 17.4276 34.136C17.4596 34.232 17.481 34.3813 17.4916 34.584C17.5023 34.7867 17.5076 35.064 17.5076 35.416C17.5076 35.7893 17.5023 36.0827 17.4916 36.296C17.481 36.5093 17.4596 36.6693 17.4276 36.776C17.4063 36.8827 17.369 36.9467 17.3156 36.968C17.273 36.9893 17.2196 37 17.1556 37H14.5156C14.4516 37 14.3983 36.9893 14.3556 36.968C14.3023 36.9467 14.265 36.888 14.2436 36.792C14.2116 36.6853 14.1903 36.5307 14.1796 36.328C14.169 36.1253 14.1636 35.848 14.1636 35.496C14.1636 35.1227 14.169 34.8293 14.1796 34.616C14.1903 34.4027 14.2116 34.248 14.2436 34.152C14.265 34.0453 14.3023 33.9813 14.3556 33.96C14.3983 33.928 14.4516 33.912 14.5156 33.912H17.1556ZM19.7963 33.912C19.8603 33.912 19.9136 33.928 19.9563 33.96C20.0096 33.9813 20.0469 34.04 20.0683 34.136C20.1003 34.232 20.1216 34.3813 20.1323 34.584C20.1429 34.7867 20.1483 35.064 20.1483 35.416C20.1483 35.7893 20.1429 36.0827 20.1323 36.296C20.1216 36.5093 20.1003 36.6693 20.0683 36.776C20.0469 36.8827 20.0096 36.9467 19.9563 36.968C19.9136 36.9893 19.8603 37 19.7963 37H17.1562C17.0922 37 17.0389 36.9893 16.9962 36.968C16.9429 36.9467 16.9056 36.888 16.8842 36.792C16.8522 36.6853 16.8309 36.5307 16.8202 36.328C16.8096 36.1253 16.8042 35.848 16.8042 35.496C16.8042 35.1227 16.8096 34.8293 16.8202 34.616C16.8309 34.4027 16.8522 34.248 16.8842 34.152C16.9056 34.0453 16.9429 33.9813 16.9962 33.96C17.0389 33.928 17.0922 33.912 17.1562 33.912H19.7963ZM22.4369 33.912C22.5009 33.912 22.5542 33.928 22.5969 33.96C22.6502 33.9813 22.6875 34.04 22.7089 34.136C22.7409 34.232 22.7622 34.3813 22.7729 34.584C22.7835 34.7867 22.7889 35.064 22.7889 35.416C22.7889 35.7893 22.7835 36.0827 22.7729 36.296C22.7622 36.5093 22.7409 36.6693 22.7089 36.776C22.6875 36.8827 22.6502 36.9467 22.5969 36.968C22.5542 36.9893 22.5009 37 22.4369 37H19.7969C19.7329 37 19.6795 36.9893 19.6369 36.968C19.5835 36.9467 19.5462 36.888 19.5249 36.792C19.4929 36.6853 19.4715 36.5307 19.4609 36.328C19.4502 36.1253 19.4449 35.848 19.4449 35.496C19.4449 35.1227 19.4502 34.8293 19.4609 34.616C19.4715 34.4027 19.4929 34.248 19.5249 34.152C19.5462 34.0453 19.5835 33.9813 19.6369 33.96C19.6795 33.928 19.7329 33.912 19.7969 33.912H22.4369ZM25.0775 33.912C25.1415 33.912 25.1948 33.928 25.2375 33.96C25.2908 33.9813 25.3282 34.04 25.3495 34.136C25.3815 34.232 25.4028 34.3813 25.4135 34.584C25.4242 34.7867 25.4295 35.064 25.4295 35.416C25.4295 35.7893 25.4242 36.0827 25.4135 36.296C25.4028 36.5093 25.3815 36.6693 25.3495 36.776C25.3282 36.8827 25.2908 36.9467 25.2375 36.968C25.1948 36.9893 25.1415 37 25.0775 37H22.4375C22.3735 37 22.3202 36.9893 22.2775 36.968C22.2242 36.9467 22.1868 36.888 22.1655 36.792C22.1335 36.6853 22.1122 36.5307 22.1015 36.328C22.0908 36.1253 22.0855 35.848 22.0855 35.496C22.0855 35.1227 22.0908 34.8293 22.1015 34.616C22.1122 34.4027 22.1335 34.248 22.1655 34.152C22.1868 34.0453 22.2242 33.9813 22.2775 33.96C22.3202 33.928 22.3735 33.912 22.4375 33.912H25.0775ZM26.0541 33.912C26.1181 33.912 26.1768 33.8907 26.2301 33.848C26.2835 33.7947 26.3101 33.7307 26.3101 33.656V31.272H29.2061V33.912C29.2061 34.424 29.1315 34.872 28.9821 35.256C28.8435 35.64 28.6461 35.96 28.3901 36.216C28.1341 36.472 27.8248 36.6693 27.4621 36.808C27.1101 36.936 26.7261 37 26.3101 37H25.0781C25.0141 37 24.9608 36.9893 24.9181 36.968C24.8648 36.9467 24.8275 36.888 24.8061 36.792C24.7741 36.6853 24.7528 36.5307 24.7421 36.328C24.7315 36.1253 24.7261 35.848 24.7261 35.496C24.7261 35.1227 24.7315 34.8293 24.7421 34.616C24.7528 34.4027 24.7741 34.248 24.8061 34.152C24.8275 34.0453 24.8648 33.9813 24.9181 33.96C24.9608 33.928 25.0141 33.912 25.0781 33.912H26.0541ZM29.6541 40.072H25.0781V37.864H29.6541V40.072ZM36.7923 36.648C36.7923 37.352 36.6909 37.9707 36.4883 38.504C36.2963 39.048 36.0189 39.5013 35.6563 39.864C35.2936 40.2267 34.8616 40.4987 34.3602 40.68C33.8696 40.872 33.3309 40.968 32.7443 40.968H30.3603L30.1842 37.88H32.9203C33.2723 37.88 33.5176 37.8107 33.6562 37.672C33.8056 37.5333 33.8802 37.3093 33.8802 37H33.6243C32.9629 37 32.4189 36.9253 31.9923 36.776C31.5656 36.6267 31.2296 36.4187 30.9843 36.152C30.7496 35.8747 30.5843 35.5387 30.4883 35.144C30.4029 34.7493 30.3603 34.312 30.3603 33.832C30.3603 33.3733 30.4296 32.936 30.5683 32.52C30.7069 32.104 30.9096 31.7413 31.1763 31.432C31.4536 31.112 31.7896 30.8613 32.1843 30.68C32.5789 30.488 33.0269 30.392 33.5283 30.392C33.9656 30.392 34.3816 30.456 34.7763 30.584C35.1709 30.712 35.5176 30.92 35.8163 31.208C36.1149 31.4853 36.3496 31.848 36.5203 32.296C36.7016 32.7333 36.7923 33.272 36.7923 33.912V36.648ZM33.0963 33.64C33.0963 33.8107 33.1283 33.944 33.1923 34.04C33.2563 34.136 33.4003 34.184 33.6243 34.184H34.0563V33.736C34.0563 33.3307 33.8909 33.128 33.5603 33.128C33.2509 33.128 33.0963 33.2987 33.0963 33.64Z"/>
                            </svg>
                            </span>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
            </div>
            


            
            <?php if($product->photos->count()): ?>
                <div thumbsSlider="" class="swiper mySwiper">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <img src="<?php echo e(asset($product->single_image)); ?>"/>
                        </div>
                        <?php $__currentLoopData = $product->photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="swiper-slide">
                                <img src="<?php echo e(asset($photo->path)); ?>"/>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>
            
        </div>
        <!--product photos end-->

        <!--product details-->
        <div class="col-md-12 col-xl-8">
            <!--product title and price-->
            <div class="single-product-title">
                <h1><?php echo e($product->title); ?></h1>
                <p class="subtitle"><?php echo e($product->english_title); ?></p>
            </div>

            <!--product title and price end-->
            <div class="row">
                <div class="col-md-12 col-xl-7">
                    <div class="single-product-details">
                        <div class="product-meta">
                            <div class="product-rating">
                                <a href="#">
                                    <i class="fi fi-rr-star align-middle"></i>
                                    <?php if($product->reviews->whereNull('parent_id')->where('status')->count()): ?>
                                        <?php echo e(get_review_average($product)); ?>

                                        از
                                        <?php echo e($product->reviews->whereNotNull('rate')->count()); ?>

                                        نظر
                                    <?php else: ?>
                                        بدون امتیاز
                                    <?php endif; ?>
                                </a>
                            </div>

                            <div class="product-comments">
                                <a href="#">
                                    <i class="fi fi-rr-comment align-middle"></i>
                                    <?php echo e($product->reviews->whereNull('parent_id')->where('status')->count()); ?>

                                    دیدگاه
                                </a>
                            </div>
                        </div>

                        <!--product description-->
                        <div class="single-product-details-body">
                            <?php if($product->brand): ?>
                                <p class="subtitle mt-2">
                                    برند:
                                    <?php echo e($product->brand); ?>

                                </p>
                            <?php endif; ?>
                            <div class="product-desc">
                                <?php echo $product->short_description; ?>

                            </div>
                                <?php if($product->attributes->count()): ?>
                                    <strong>ویژگی ها: </strong>
                                    <ul class="mt-2 mb-2">
                                        <?php $__currentLoopData = $product->attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="d-flex">
                                                <p><?php echo e($attr->name); ?>:</p>
                                                <p><?php echo e($attr->pivot->value->value); ?></p>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                <?php endif; ?>
                            <div class="min-order-quantity">
                                <a href="#">
                                    <i class="fi fi-rr-info align-middle line-height-1"></i>
                                    حداقل تعداد سفارش:
                                    <?php echo e($product->min_order_quantity); ?>

                                    عدد
                                </a>
                            </div>
                            <?php if(!$product->is_in_inventory() || $product->is_inventory_less_than_min_order_quantity()): ?>
                                <div class="alert alert-danger" role="alert">
                                    متاسفانه این محصول در انبار موجود نمیباشد.
                                </div>
                            <?php endif; ?>
                            <div
                                class="product-info br-1 mb-3 d-flex align-items-center justify-content-center mobile-price">
                                <div class="product-price flex-column">
                                    <?php if(!$product->is_inventory_less_than_min_order_quantity()): ?>
                                        <?php if($product->is_in_inventory()): ?>
                                            <?php if($product->is_on_sale()): ?>
                                                <div class="d-flex justify-content-center align-items-center">
                                                    <p class="old-price">
                                                        <?php echo e(number_format($product->price)); ?>

                                                        تومان
                                                    </p>
                                                    <span class="discount">
                                        <?php
                                            $percentage = round(100 - ($product->sale_price / $product->price * 100));
                                        ?>
                                                        <?php echo e($percentage); ?> %
                                    </span>
                                                </div>
                                                <p class="new-price">
                                                    <?php echo e(number_format($product->sale_price)); ?>

                                                    تومان
                                                </p>

                                            <?php else: ?>
                                                <p class="new-price">
                                                    <?php echo e(number_format($product->price)); ?>

                                                    تومان
                                                </p>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            0 تومان
                                        <?php endif; ?>
                                    <?php else: ?>
                                        0 تومان
                                    <?php endif; ?>
                                </div>
                            </div>

                        </div>
                        <!--product description end-->

                        <div class="product-divider"></div>

                        <div class=" d-flex align-items-center justify-content-between add-to-cart-btn">
                            <?php if(!$product->is_inventory_less_than_min_order_quantity()): ?>
                                <?php if($product->is_in_inventory()): ?>

                                    <div class="product-quantity">
                                        <input type="number" min="<?php echo e($product->min_order_quantity); ?>"
                                               max="<?php echo e($product->inventory); ?>" class="form-control quantity"
                                               value="<?php echo e($product->min_order_quantity); ?>" id="add-to-cart-quantity"
                                               name="quantity">
                                    </div>
                                    <div class="single-product-form">
                                        <button class="btn btn-default product-btn w-100 br-1" id="product-btn-variable"
                                                onclick="addToCartSingleProduct(<?php echo e($product->id); ?>)">
                                            <span class="add-to-cart-loader" style="display: none;">
                                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="margin: auto;" width="30px" height="30px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid">
                                                <circle cx="50" cy="50" r="32" stroke-width="8" stroke="#ffa701" stroke-dasharray="50.26548245743669 50.26548245743669" fill="none" stroke-linecap="round">
                                                    <animateTransform attributeName="transform" type="rotate" repeatCount="indefinite" dur="1s" keyTimes="0;1"   values="0 50 50;360 50 50"/>
                                                </circle>
                                            </svg>
                                            </span>
                                            <span class="add-to-cart-text">
                                                <i class="fi fi-rr-shopping-bag-add"></i>
                                            افزودن به سبد
                                            </span>

                                        </button>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>

                        <!--product footer-->
                        <div class="single-product-footer">
                            <div class="free-shipping box-shadowed br-1">
                                <div class="text">
                                    <span>ارسال رایگان</span>
                                    <span class="subtitle">برای سفارش‌ بالای ۵۰۰ هزار تومان</span>
                                </div>
                                <img src="/images/elements/free-delivery.svg" alt="">
                            </div>
                        </div>
                        <!--product footer end-->

                    </div>
                </div>
                <div class="col-xl-5 mt-3">
                    <div class="product-info br-1 mb-3 d-flex align-items-center justify-content-center desktop-price">
                        <div class="product-price flex-column">
                            <?php if(!$product->is_inventory_less_than_min_order_quantity()): ?>
                                <?php if($product->is_in_inventory()): ?>
                                    <?php if($product->is_on_sale()): ?>
                                        <div class="d-flex justify-content-center align-items-center">
                                            <p class="old-price">
                                                <?php echo e(number_format($product->price)); ?>

                                                تومان
                                            </p>
                                            <span class="discount">
                                        <?php
                                            $percentage = round(100 - ($product->sale_price / $product->price * 100));
                                        ?>
                                                <?php echo e($percentage); ?> %
                                    </span>
                                        </div>
                                        <p class="new-price">
                                            <?php echo e(number_format($product->sale_price)); ?>

                                            تومان
                                        </p>

                                    <?php else: ?>
                                        <p class="new-price">
                                            <?php echo e(number_format($product->price)); ?>

                                            تومان
                                        </p>
                                    <?php endif; ?>
                                <?php else: ?>
                                    0 تومان
                                <?php endif; ?>
                            <?php else: ?>
                                0 تومان
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="seller-garanty">
                        <a href="#">
                            <i class="fi fi-rr-shield-check align-middle"></i>
                            گارانتی اصالت و سلامت فیزیکی کالا
                        </a>
                    </div>
                    <div class="shipping-date">
                        <a href="#">
                            <i class="fi fi-rr-truck-moving align-middle line-height-1"></i>
                            مدت زمان ارسال:
                            5 روز کاری
                        </a>
                    </div>

                    <div class="meta">
                        <?php if($product->sku): ?>
                            <p class="meta-cat">
                                شناسه محصول:
                                <?php echo e($product->sku); ?>

                            </p>
                        <?php endif; ?>
                        <?php if($product->categories): ?>
                            <ul class="meta-cat">دسته بندی:
                                <?php $__currentLoopData = $product->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <a href="<?php echo e(route('product-category.show' , $category)); ?>"><?php echo e($category->name); ?>

                                            ،</a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        <?php else: ?>
                            <p class="meta-cat">دسته نشده </p>
                        <?php endif; ?>
                    </div>
                </div>
                <!--product details end-->
            </div>
        </div>
    </div>
</section>
<?php $__env->startSection('head'); ?>
    <link rel="stylesheet" href="https://unpkg.com/swiper@8/swiper-bundle.min.css"/>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
    <script src="<?php echo e(asset('/frontend/js/single-product.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php /**PATH /home/icworldco/core/Modules/Product/Resources/views/frontend/single-product/partials/product-details.blade.php ENDPATH**/ ?>