<?php $__env->startComponent('backend.layouts.components.main',['title' => 'مدیریت سفارشات', 'titleBar'=>true , 'button' => 'افزودن سفارش' , 'route' => 'admin.orders.create']); ?>

    <?php $__env->slot('breadcrumb'); ?>
        <li class="breadcrumb-item active">
            <a href="<?php echo e(route('admin.index')); ?>">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">سفارشات</li>
    <?php $__env->endSlot(); ?>

    
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست سفارشات</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <tbody>
                        <tr>
                            <th>کد سفارش</th>
                            <th>نام کاربر</th>
                            <th>هزینه</th>
                            <th>وضعیت</th>
                            <th>شماره پیگیری</th>
                            <th>زمان ثبت</th>
                            <th>ارسال به</th>
                            <th>اقدامات</th>
                        </tr>

                        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>#<?php echo e($order->order_code); ?></td>
                                <td><?php echo e($order->user->name); ?></td>
                                <td><?php echo e(number_format($order->price)); ?>

                                    تومان
                                </td>
                                <td>
                                    <?php switch($order->status):
                                        case ('paid'): ?>
                                        <span class="badge badge-success">پرداخت شده</span>
                                        <?php break; ?>
                                        <?php case ('preparation'): ?>
                                        <span class="badge badge-success">در حال پردازش</span>
                                        <?php break; ?>
                                        <?php case ('unpaid'): ?>
                                        <span class="badge badge-warning">پرداخت نشده</span>
                                        <?php break; ?>
                                        <?php case ('canceled'): ?>
                                        <span class="badge badge-danger">لغو شده</span>
                                        <?php break; ?>
                                        <?php case ('posted'): ?>
                                        <span class="badge badge-success">ارسال شده</span>
                                        <?php break; ?>
                                        <?php case ('received'): ?>
                                        <span class="badge badge-success">رسیده به مشتری</span>
                                        <?php break; ?>
                                    <?php endswitch; ?>

                                </td>
                                <td><?php echo e($order->tracking_serial ?? 'ثبت نشده'); ?></td>
                                <td><?php echo e(\Hekmatinasser\Verta\Verta::instance($order->created_at)->formatJalaliDate()); ?></td>
                                <td title="<?php echo e($order->address->address); ?>"><?php echo e($order->address->city->name); ?></td>
                                <td class="d-flex">
                                    
                                    <a href="<?php echo e(route('admin.orders.payments' , $order->id)); ?>" class="btn btn-sm btn-info  ml-1"> پرداخت‌ها</a>
                                    <a href="<?php echo e(route('admin.orders.edit' , $order->id)); ?>" class="btn btn-sm btn-primary  ml-1">جزئیات و ویرایش</a>
                                    <form action="<?php echo e(route('admin.orders.destroy' , $order->id)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger">حذف</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        </tbody>
                    </table>
                </div>
                <?php echo e($orders->appends([ 'search' => request('search') ])->render()); ?>

            </div>
        </div>
    </div>
    
<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('/backend/js/search.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/icworld/core/Modules/Order/Resources/views/backend/all.blade.php ENDPATH**/ ?>