<?php $__env->startComponent('backend.layouts.components.main',['title' => 'مدیریت نظرات', 'titleBar'=>true , 'button' => '' , 'route' => 'admin.product-reviews.create']); ?>

    <?php $__env->slot('breadcrumb'); ?>
        <li class="breadcrumb-item active">
            <a href="<?php echo e(route('admin.index')); ?>">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">نظرات</li>
    <?php $__env->endSlot(); ?>

    
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست نظرات</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>نام</th>
                            <th>متن</th>
                            <th>امتیاز</th>
                            <th>وضعیت</th>
                            <th>در محصول</th>
                            <th>تاریخ ایجاد</th>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-product-reviews')): ?>
                                <th>عملیات</th>
                            <?php endif; ?>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <tr>
                                <td>
                                    <?php if($review->username === 'مدیریت وب سایت'): ?>
                                        <span class="badge badge-primary light">مدیر</span>
                                    <?php endif; ?>
                                        <?php echo e($review->username); ?>

                                </td>
                                <td><?php echo e($review->text); ?></td>
                                <td>
                                    <?php if(!is_null($review->rate)): ?>
                                        <?php echo e($review->rate + 1); ?>

                                    <?php else: ?>
                                        بدون امتیاز
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php switch($review->status):
                                        case (1): ?>
                                        <span class="btn btn-xs btn-rounded btn-outline-success">تایید شده</span>

                                        <?php break; ?>
                                        <?php case (0): ?>
                                        <span class="btn btn-xs btn-rounded btn-outline-warning">تایید نشده</span>

                                        <?php break; ?>
                                    <?php endswitch; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(asset('/product/' . $review->product->slug)); ?>" target="_blank"><?php echo e($review->product->title); ?></a>
                                </td>
                                <td>
                                    <?php echo e(\Hekmatinasser\Verta\Verta::instance($review->created_at)->formatJalaliDate()); ?>

                                </td>
                                <td>
                                    <form action="<?php echo e(route('admin.product-reviews.destroy', $review->id)); ?>" method="post"
                                          id="delete-<?php echo e($review->id); ?>">
                                        <?php echo method_field('delete'); ?>
                                        <?php echo csrf_field(); ?>
                                    </form>
                                    <form action="<?php echo e(route('admin.product-reviews.status', $review->id)); ?>" method="post"
                                          id="status-<?php echo e($review->id); ?>">
                                        <?php echo method_field('post'); ?>
                                        <?php echo csrf_field(); ?>
                                    </form>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-product-reviews')): ?>
                                        <button onclick="document.getElementById('delete-<?php echo e($review->id); ?>').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>

                                        <?php if($review->status == 0): ?>
                                            <a role="button"
                                               class="btn btn-success light sharp" title="تایید کردن">
                                                <i class="fa fa-check"
                                                   onclick="document.getElementById('status-<?php echo e($review->id); ?>').submit()"></i>
                                            </a>
                                        <?php else: ?>
                                            <a role="button"
                                               class="btn btn-warning light sharp" title="عدم تایید">
                                                <i class="fa fa-close"
                                                   onclick="document.getElementById('status-<?php echo e($review->id); ?>').submit()"></i>
                                            </a>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                            </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
                <?php echo e($reviews->links()); ?>

            </div>
        </div>
    </div>
    
<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('/backend/js/search.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/icworldco/core/Modules/ProductReview/Resources/views/backend/all.blade.php ENDPATH**/ ?>