@extends('backend.layouts.master')
@section('content')
    <!-- row -->
    <div class="container-fluid">
        @if($titleBar)
            <div class="d-sm-flex d-block justify-content-between align-items-center mb-4">
                <h2 class="text-black font-w600 mb-sm-0 mb-2">{{$title}}</h2>
                <form action="{{route($route)}}" method="post" id="page-create">
                    @csrf
                    @method('post')
                </form>
                <a onclick="event.preventDefault(); document.getElementById('page-create').submit()" type="button" class="btn btn-rounded btn-success light">
                    <span class="btn-icon-left text-success">
                        <i class="fa fa-plus" aria-hidden="true"></i>
						</span>{{$button}}
                </a>
                <!-- Modal -->
            </div>
        @else
            <div class="page-titles">
                <h4>{{$title}}</h4>
                <ol class="breadcrumb">
                    {{$breadcrumb}}
                </ol>
            </div>
        @endif
            <div class="row">
                {{$slot}}
            </div>
    </div>


@stop
