<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Route;

Route::prefix('profile')->namespace('Front')->middleware('auth')->group(function() {
    Route::get('/', 'UserController@index')->name('profile.index');
    Route::get('/orders', 'UserController@orders')->name('profile.orders');
    Route::get('/settings', 'UserController@settings')->name('profile.settings');
    Route::patch('/settings/{user}', 'UserController@settingsUpdate')->name('profile.user.update');
    Route::get('/addresses', 'UserController@addresses')->name('profile.addresses');
    Route::get('/addresses/{address}', 'UserController@addressEdit')->name('profile.address.edit');
    Route::patch('/addresses/{address}', 'UserController@addressUpdate')->name('profile.address.update');
    Route::get('/orders/{order}', 'UserController@orderDetails')->name('profile.order.show');
});
