@component('user::frontend.partials.content')
    <div class="single-product">
        <h3>آدرس های شما</h3>
        <div class="row">
            <div class="col-md-6">
                <form action="{{route('profile.address.update' , $address)}}" method="post" id="store">
                    @csrf
                    @method('patch')
                </form>
                <div class="form-group">
                    <label for="city">شهر
                        <abbr class="text-red" title="اجباری">*</abbr>
                    </label>
                    <select form="store" id="city" name="city_id"
                            class="form-select @error('city_id') is-invalid @enderror mt-2 br-1 cities-select">
                        <option value="">انتخاب کنید</option>
                        @foreach($cities as $city)
                            <option value="{{$city->id}}"
                                    @if($address->city_id == $city->id) selected @endif>{{$city->name}}</option>
                        @endforeach
                    </select>
                    @error('city')
                    <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                    @enderror
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="postal_code">شهر
                        <abbr class="text-red" title="اجباری">*</abbr>
                    </label>
                    <input form="store" type="text" name="postal_code" id="postal_code"
                           class="form-control mt-2 br-1 @error('postal_code') is-invalid @enderror "
                           value="{{old('postal_code' , $address->postal_code)}}">
                    @error('postal_code')
                    <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                    @enderror
                </div>
            </div>
        </div>
        <div class="row mt-2">
          <div class="form-group">
              <label for="address">آدرس
                  <abbr class="text-red" title="اجباری">*</abbr>
              </label>
              <textarea form="store" name="address" id="address"
                        class="form-control mt-2 br-1 @error('address') is-invalid @enderror "
                        cols="30" rows="5">{{old('address' , $address->address)}}</textarea>
              @error('address')
              <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
              @enderror
          </div>
        </div>
        <div class="form-group mt-3">
            <a onclick="event.preventDefault(); $('#store').submit()"
            class="btn btn-outline-primary">به روز رسانی</a>
        </div>
    </div>

@endcomponent
