<?php

namespace Modules\Search\Http\Controllers\Front;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Product\Entities\Product;

class SearchController extends Controller
{
    use SEOTools;

    public function index(Request $request)
    {
        $this->seo()->setTitle("جستجو برای $request->search");
        $products = Product::where('title', 'LIKE', '%' . $request->search . "%")
            ->whereStatus(1)->latest()->simplePaginate(12);
        return view('search::frontend.index' , compact('products'));
    }

    public function search(Request $request)
    {
        if ($request->ajax()) {
            $output = "";
            $products = DB::table('products')
                ->where('title', 'LIKE', '%' . $request->search . "%")
                ->orWhere('english_title', 'LIKE', '%' . $request->search . "%")
                ->whereStatus(1)->take(10)->get();
            if ($products) {
                foreach ($products as $key => $product) {
                    if($product->single_image) {
                        $img = $product->single_image;
                    }else {
                        $img = '/images/other/no-image.jpg';
                    }
                    $output .=
                        "<a href='/product/$product->slug'>".
                        '<div class="result-item">' .
                        '<img '. "src='$img'" . 'alt="">' .
                        '<div class="result-detail">' .
                        '<p>' . $product->title .'</p>' .
                        '<p class="subtitle">نمایش محصول</p>' .
                        '</div>'.
                        '</div>'.
                        '</a>';
                }
                return Response($output);
            } else {
                return Response('متاسفانه محصول مورد نظر یافت نشد');
            }
        }
    }
}
