@component('backend.layouts.components.main',['title' => 'مدیریت نظرات', 'titleBar'=>true , 'button' => '' , 'route' => 'admin.product-reviews.create'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">نظرات</li>
    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست نظرات</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>نام</th>
                            <th>متن</th>
                            <th>امتیاز</th>
                            <th>وضعیت</th>
                            <th>در محصول</th>
                            <th>تاریخ ایجاد</th>
                            @can('manage-product-reviews')
                                <th>عملیات</th>
                            @endcan
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($reviews as $review)

                            <tr>
                                <td>
                                    @if($review->username === 'مدیریت وب سایت')
                                        <span class="badge badge-primary light">مدیر</span>
                                    @endif
                                        {{$review->username}}
                                </td>
                                <td>{{$review->text}}</td>
                                <td>
                                    @if(!is_null($review->rate))
                                        {{$review->rate + 1}}
                                    @else
                                        بدون امتیاز
                                    @endif
                                </td>
                                <td>
                                    @switch($review->status)
                                        @case(1)
                                        <span class="btn btn-xs btn-rounded btn-outline-success">تایید شده</span>

                                        @break
                                        @case(0)
                                        <span class="btn btn-xs btn-rounded btn-outline-warning">تایید نشده</span>

                                        @break
                                    @endswitch
                                </td>
                                <td>
                                    <a href="{{asset('/product/' . $review->product->slug)}}" target="_blank">{{$review->product->title}}</a>
                                </td>
                                <td>
                                    {{\Hekmatinasser\Verta\Verta::instance($review->created_at)->formatJalaliDate()}}
                                </td>
                                <td>
                                    <form action="{{route('admin.product-reviews.destroy', $review->id)}}" method="post"
                                          id="delete-{{$review->id}}">
                                        @method('delete')
                                        @csrf
                                    </form>
                                    <form action="{{route('admin.product-reviews.status', $review->id)}}" method="post"
                                          id="status-{{$review->id}}">
                                        @method('post')
                                        @csrf
                                    </form>
                                    @can('manage-product-reviews')
                                        <button onclick="document.getElementById('delete-{{$review->id}}').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>

                                        @if($review->status == 0)
                                            <a role="button"
                                               class="btn btn-success light sharp" title="تایید کردن">
                                                <i class="fa fa-check"
                                                   onclick="document.getElementById('status-{{$review->id}}').submit()"></i>
                                            </a>
                                        @else
                                            <a role="button"
                                               class="btn btn-warning light sharp" title="عدم تایید">
                                                <i class="fa fa-close"
                                                   onclick="document.getElementById('status-{{$review->id}}').submit()"></i>
                                            </a>
                                        @endif
                                    @endcan
                                </td>
                            </tr>

                        @endforeach
                        </tbody>
                    </table>

                </div>
                {{$reviews->links()}}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
