<?php

namespace Modules\ProductReview\Http\Controllers\Front;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\ProductReview\Entities\ProductReview;

class ProductReviewController extends Controller
{
    public function store(Request $request)
    {
        $validData = $request->validate([
            'username' => 'required|min:3',
            'product_id' => 'required',
            'text' => 'required',
            'rate' => 'nullable',
        ]);

        ProductReview::create($validData);

        alert()->toast('نظر با موفقیت ارسال شد', 'success');;

        return back();
    }

    public function reply(Request $request)
    {
        $validData = $request->validate([
            'product_id' => 'required',
            'parent_id' => 'required',
            'text' => 'required',
        ]);

        $reviewReply = new ProductReview();
        $reviewReply->username = 'مدیریت وب سایت';
        $reviewReply->parent_id = $validData['parent_id'];
        $reviewReply->product_id = $validData['product_id'];
        $reviewReply->text = $validData['text'];
        $reviewReply->status = 1;

        $reviewReply->save();

        alert()->toast('نظر با موفقیت ارسال شد', 'success');;
        return back();
    }
}
