<?php

namespace Modules\ProductReview\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Product\Entities\Product;

class ProductReview extends Model
{
    use HasFactory;

    protected $fillable = ['username' , 'rate' , 'text' , 'parent_id' , 'product_id' , 'status'];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function children()
    {
        return $this->hasMany(ProductReview::class , 'parent_id' , 'id');
    }

}
