<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


use Illuminate\Support\Facades\Route;

Route::prefix('product')->group(function() {
    Route::get('{product:slug}', 'Front\ProductController@show')->name('product.show');
});

Route::namespace('Front')->group(function () {
    Route::get('product/category/{category:slug}' , 'ProductCategoryController@show')->name('product-category.show');
    Route::post('product/category/{category}' , 'ProductCategoryController@searchCategory');
});
