@foreach($reviews as $review)
    <div class="review-item @if($reply_review) reply-review @endif">
        <div class="user-avatar">
            <img src="{{asset('/images/default_user.png')}}" alt="user-1">
        </div>
        <div class="review-details">
            <div class="review-header">
                <h4 class="username">{{$review->username}}</h4>
                <span
                    class="review-date">{{\Hekmatinasser\Verta\Verta::instance($review->created_at)->formatJalaliDate()}}</span>
            </div>
            @if($review->rate)
                <div class="review-rating">
                    <i class="bi bi-star-fill"></i>
                    {{$review->rate + 1}}
                </div>
            @endif
            <p class="review-message">{{$review->text}}</p>
            @auth
                @if(auth()->user()->isAdmin())
                    <form action="{{route('review.adminReply')}}" method="post">
                        @csrf
                        @method('post')
                        <input type="hidden" name="parent_id" value="{{$review->id}}">
                        <input type="hidden" name="product_id" value="{{$product->id}}">
                        <div class="d-flex justify-content-end">
                            <a class="btn btn-default-outline btn-sm" onclick="openReviewBox({{$review->id}})">پاسخ</a>
                        </div>
                        <div id="review-reply-box-{{$review->id}}" style="display: none">
                            <textarea name="text" id="reply-textarea" cols="30" rows="5"
                                      class="form-control br-1 mt-3"></textarea>
                            <button type="submit" class="btn btn-default-outline btn-sm mt-3 mb-3">ارسال پاسخ</button>
                        </div>
                    </form>
                @endif
            @endauth
        </div>
    </div>
    @if($review->children->count())
        @include('product::frontend.single-product.partials.review.review' ,
    [
    'reviews' => $review->children->where('status' , 1),
    'reply_review' => true
    ])

    @endif
@endforeach
