<?php

namespace Modules\Product\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Modules\Attribute\Entities\Attribute;
use Modules\Attribute\Entities\ProductAttributeValue;
use Modules\Category\Entities\Category;
use Modules\Discount\Entities\Discount;
use Modules\Order\Entities\Order;
use Modules\Photo\Entities\Photo;
use Modules\Price\Entities\Price;
use Modules\ProductReview\Entities\ProductReview;
use Modules\User\Entities\User;


class Product extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'long_description',
        'short_description',
        'price',
        'sale_price',
        'inventory',
        'is_single_sell',
        'sku',
        'brand',
        'brand_logo',
        'meta_title',
        'meta_description',
        'meta_keywords',
        'slug',
        'status',
        'single_image',
        'english_title',
        'min_order_quantity',
        'price_id',
        'pin_count'
    ];
    public function categories()
    {
        return $this->morphToMany(Category::class, 'categorizable');
    }

    public function photos()
    {
        return $this->belongsToMany(Photo::class);
    }

    public function price()
    {
        return $this->belongsTo(Price::class);
    }

    public function discounts()
    {
        return $this->hasMany(Discount::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function attributes()
    {
        return $this->belongsToMany(Attribute::class)->withPivot(['value_id'])->using(ProductAttributeValue::class);
    }

    public function reviews()
    {
        return $this->hasMany(ProductReview::class);
    }

    public function orders()
    {
        return $this->belongsToMany(Order::class);
    }

    public function is_on_sale()
    {
        if ($this->sale_price) {
            return true;
        }
        return false;
    }

    public function is_in_inventory()
    {
        if (!is_null($this->inventory)) {
            if (!$this->inventory == 0) {
                return true;
            }
            return false;
        }
        return true;
    }

    public function is_inventory_less_than_min_order_quantity()
    {
        if (!is_null($this->inventory)) {
            if ($this->inventory < $this->min_order_quantity) {
                return true;
            }
            return false;
        }
    }

    public
    function has_thumbnail()
    {
        if (!is_null($this->single_image)) {
            return true;
        }
        return false;
    }

    public
    function is_active()
    {
        if ($this->status != 0) {
            return true;
        }
        return false;
    }


}
