@component('frontend.layouts.components.page' , ['title' => 'وبلاگ'])
    @section('head')
        {!! JsonLd::generate() !!}
    @stop
    @slot('breadcrumb')
        <li class="tm-breadcrumb-item">وبلاگ</li>
    @endslot
    <div class="container mt-5 mb-5">
        <div class="row">
            <div class="col-md-12">
                <div class="row">
                    @if($posts->count())
                        @foreach($posts as $post)
                            <div class="col-xl-3">
                                <div class="post-card mb-3 br-1 single-product">
                                    <figure class="post-image">
                                        <a href="{{route('post.show' , $post)}}">
                                            @if($post->image)
                                                <img src="{{asset($post->image)}}" alt="" class="br-1">
                                            @else
                                                <img src="/images/other/no-image.jpg" alt="" class="br-1">
                                            @endif
                                        </a>
                                    </figure>
                                    <div class="post-details">
                                        <div class="post-meta">
                                            تاریخ انتشار:
                                            <a href="#" class="post-date">
                                                {{\Hekmatinasser\Verta\Verta::instance($post->created_at)->formatJalaliDate()}}
                                            </a>
                                        </div>
                                        <h4 class="post-title font-small">
                                            <a href="{{route('post.show' , $post)}}">{{$post->title}}</a>
                                        </h4>
                                        <div class="post-footer">
                                            <a href="{{route('post.show' , $post)}}" class="btn btn-link">
                                                بیشتر بخوانید
                                                <i class="fi fi-rr-arrow-left"></i>
                                            </a>
                                            <div class="post-comments">
                                                <a href="#">
                                                    {{$post->comments->count()}}
                                                    <i class="fi fi-rr-comment line-height-0 align-middle"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @else
                        <div class="default-alert">
                            هنوز مقاله ای ثبت نشده است
                        </div>
                    @endif
                </div>
                {{$posts->links()}}
            </div>
        </div>

    </div>

@endcomponent
