@component('backend.layouts.components.main',['title' => 'مدیریت پست ها', 'titleBar'=>true , 'button' => 'افزودن پست' , 'route' => 'admin.posts.create'])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">پست ها</li>
    @endslot

    {{-- Table Start --}}
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست پست ها</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>نام</th>
                            <th>دسته بندی</th>
                            <th>تاریخ ایجاد</th>
                            @can('manage-posts')
                                <th>عملیات</th>
                            @endcan
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($posts as $post)

                            <tr>
                                <td>{{$post->title}}</td>
                                <td>
                                    @foreach($post->categories as $category)
                                        @if(count($post->categories)>1)
                                            {{$category->name . ','}}
                                        @else
                                            {{$category->name}}
                                        @endif
                                    @endforeach
                                </td>
                                <td>{{\Hekmatinasser\Verta\Verta::instance($post->created_at)->formatJalaliDate()}}</td>

                                <td>
                                    <form action="{{route('admin.posts.destroy', $post->id)}}" method="post"
                                          id="delete-{{$post->id}}">
                                        @method('delete')
                                        @csrf
                                    </form>
                                    @can('manage-users')
                                        <a href="{{route('admin.posts.edit', $post->id)}}" role="button"
                                           class="btn btn-success light sharp" title="ویرایش">
                                            <i class="fa fa-pencil"
                                               onclick="document.getElementById('edit-{{$post->id}}').submit()"></i>
                                        </a>
                                        <button onclick="document.getElementById('delete-{{$post->id}}').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    @endcan
                                    <a href="{{asset('blog/' . $post->slug)}}" role="button"
                                       class="btn btn-primary light sharp" title="نمایش" target="_blank">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                </td>

                            </tr>

                        @endforeach
                        </tbody>
                    </table>

                </div>
                {{$posts->links()}}
            </div>
        </div>
    </div>
    {{-- Table End --}}
@section('script')
    <script src="{{asset('/backend/js/search.js')}}"></script>
@stop
@endcomponent
