<?php

namespace Modules\Payment\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;
use Modules\Payment\Notifications\channels\SmsPanel;

class PaymentSuccessNotification extends Notification
{
    use Queueable;

    public $order_code;

    public $name;

    public $phone;

    public $price;


    public function __construct( $phone , $order_code , $price , $name)
    {
        $this->order_code = $order_code;
        $this->name = $name;
        $this->price = $price;
        $this->phone = $phone;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return [SmsPanel::class];
    }

    public function toSmsPanel($notifiable)
    {
        return [
            'phone' => $this->phone,
            'order_code' => $this->order_code,
            'name' => $this->name,
            'price' => $this->price,
        ];
    }
}
