<?php

namespace Modules\Order\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Address\Entities\Address;
use Modules\Payment\Entities\Payment;
use Modules\Product\Entities\Product;
use Modules\Shipping\Entities\Shipping;
use Modules\User\Entities\User;
use Illuminate\Notifications\Notifiable;

class Order extends Model
{
    use HasFactory;
    use Notifiable;

    protected $fillable = ['price' , 'status' , 'track_id' , 'shipping_id' , 'address_id' , 'notes' , 'order_code'];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function products()
    {
        return $this->belongsToMany(Product::class)->withPivot(['quantity' , 'price']);
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }
    public function shipping()
    {
        return $this->belongsTo(Shipping::class);
    }

    public function address()
    {
        return $this->belongsTo(Address::class);
    }
}
