<?php

namespace Modules\LoginWithCode\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\User\Entities\User;

class Code extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'code',
        'expired_at'
    ];

    public $timestamps = false;

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function scopeVerifyCode($query, $code, $user)
    {
        return !!$user->activeCode()->whereCode($code)->where('expired_at', '>', now())->first();
    }

    public function scopeGenerateCode($query, $user)
    {

        $user->activeCode()->delete();

        do {
            $code = mt_rand(1000, 9999);
        } while ($this->checkCodeIsUnique($user, $code));

        // store the code
        $user->activeCode()->create([
            'code' => $code,
            'expired_at' => now()->addMinutes(10)
        ]);

        return $code;
    }

    private function checkCodeIsUnique($user, int $code)
    {
        return !!$user->activeCode()->whereCode($code)->first();
    }

    private function getAliveCodeForUser($user)
    {
        return $user->activeCode()->where('expired_at', '>', now())->first();
    }
}
