@component('backend.layouts.components.main',['title' => 'مدیریت کد تخفیف','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">ویرایش کد تخفیف</li>
        <li class="breadcrumb-item">{{$discount->name}}</li>
    @endslot
    {{-- Section Start --}}
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">جزئیات کد تخفیف</h4>
            </div>
            <div class="card-body">
                <div class="basic-form">
                    <form action="{{route('admin.discounts.update' , $discount->id)}}" method="post" id="update">
                        @csrf
                        @method('patch')
                        <div class="form-group">
                            <label for="inputEmail3" class="control-label">کد تخفیف</label>
                            <input type="text" name="code" class="form-control  @error('code') is-invalid @enderror"
                                   id="inputEmail3" placeholder="کد تخفیف را وارد کنید" value="{{ old('code', $discount->code) }}">
                        </div>
                        <div class="form-group">
                            <label for="precent" class="control-label">میزان تخفیف (درصد)</label>
                            <input type="number" name="percent"
                                   class="form-control  @error('percent') is-invalid @enderror"
                                   placeholder="درصد تخفیف را وارد کنید" value="{{ old('code', $discount->percent) }}">
                        </div>
                        <div class="form-group">
                            <label class=" control-label"> کاربر استفاده کننده (اختیاری)</label>
                            <select class="form-control  @error('users') is-invalid @enderror" name="users[]" id="users"
                                    multiple>
                                @foreach(\Modules\User\Entities\User::all() as $user)
                                    <option
                                        value="{{ $user->id }}" {{ $discount->users && in_array($user->id , $discount->users->pluck('id')->toArray()) ? 'selected' : '' }}>{{\Modules\User\Entities\User::find($user->id)->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="inputPassword3" class="control-label">محصول مربوطه (اختیاری)</label>
                            <select class="form-control  @error('products') is-invalid @enderror" name="products[]"
                                    id="products" multiple>
                                @foreach(\Modules\Product\Entities\Product::all() as $product)
                                    <option
                                        value="{{ $product->id }}" {{ $discount->products && in_array($product->id , $discount->products->pluck('id')->toArray()) ? 'selected' : '' }}>{{ \Modules\Product\Entities\Product::find($product->id)->title }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="inputPassword3" class="control-label">دسته‌بندی مربوطه (اختیاری)</label>
                            <select class="form-control  @error('categories') is-invalid @enderror" name="categories[]"
                                    id="categories" multiple>
                                @foreach(\Modules\Category\Entities\Category::where('category_type' , \Modules\Product\Entities\Product::class)->get() as $category)
                                    <option
                                        value="{{ $category->id }}" {{ in_array($category->id , $discount->categories->pluck('id')->toArray()) ? 'selected' : '' }}>{{ $category->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="inputEmail3" class="col-sm-2 control-label">مهلت استفاده</label>
                            <input type="datetime-local" name="expired_at" class="form-control" id="inputEmail3" placeholder="ملهت استفاده را وارد کنید" value="{{ old('expired_at' , \Carbon\Carbon::parse($discount->expired_at)->format('Y-m-d\TH:i:s')) }}">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}
    <div class="col-md-4">
        <div class="sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.discounts.index')}}" role="button" class="btn btn-xs btn-info light"
                   title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای اعمال تغییرات روی دکمه ی به روز رسانی کلیک کنید.
                </p>
                <p class="text-justify">
                    <i class="fa fa-circle text-warning ml-1"></i>
                    در صورت حذف، آیتم مورد نظر برای همیشه حذف شده و راهی برای بازگشت آن وجود ندارد.
                </p>
                <div class="row">
                    <form action="{{route('admin.discounts.destroy', $discount->id)}}" method="post"
                          id="delete-{{$discount->id}}">
                        @method('delete')
                        @csrf
                    </form>
                    <div class="col-md-6">
                        <button class="btn btn-danger btn-sm btn-block light"
                                onclick="document.getElementById('delete-{{$discount->id}}').submit()">
                            <i class="fa fa-trash"></i>
                            حذف
                        </button>
                    </div>
                    <div class="col-md-6">
                        <button class="btn btn-success btn-sm btn-block light"
                                onclick="document.getElementById('update').submit()">
                            <i class="fa fa-refresh"></i>
                            به روز رسانی
                        </button>
                    </div>
                </div>

            </div>
        </div>
    </div>
    {{-- Sidebar End --}}
@section('head')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet"/>
@stop
@section('script')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>

        $('#users').select2({
            'placeholder': 'کاربر مورد نظر را انتخاب کنید'
        })

        $('#products').select2({
            'placeholder': 'محصول مورد نظر را انتخاب کنید'
        })

        $('#categories').select2({
            'placeholder': 'دسته مورد نظر را انتخاب کنید'
        })
    </script>
@stop
@endcomponent
