@foreach($categories as $category)
    <tr>
        <td>
            {{ str_repeat('---' , $level) . ' ' . $category->name}}
        </td>
        <td>
            @if($category->cat_image)
                <span class="badge badge-sm badge-success">تصویر دارد</span>
            @else
                <span class="badge badge-sm badge-warning">تصویر ندارد</span>

            @endif
        </td>
        <td>
            <form action="{{route('admin.categories-posts.destroy', $category->id)}}" method="post"
                  id="delete-{{$category->id}}">
                @method('delete')
                @csrf
            </form>
            <a href="{{route('admin.categories-posts.edit',$category->id) }}" role="button"
               class="btn btn-success light sharp" title="ویرایش">
                <i class="fa fa-pencil"
                   onclick="document.getElementById('edit-{{$category->id}}').submit()"></i>
            </a>
            <button onclick="document.getElementById('delete-{{$category->id}}').submit()"
                    role="button" class="btn btn-danger light sharp" title="حذف">
                <i class="fa fa-trash"></i>
            </button>

        </td>
        @if($category->children->count())
            @include('category::backend.posts.partials.categories-group' ,
            ['categories' => $category->children , 'child' => true , 'level' => $level+1])
        @endif
    </tr>
@endforeach
